#  File src/library/base/R/scale.R
#  Part of the R package, https://www.R-project.org
#
#  Copyright (C) 1995-2018 The R Core Team
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  A copy of the GNU General Public License is available at
#  https://www.R-project.org/Licenses/

scale <- function(x, center = TRUE, scale = TRUE) UseMethod("scale")

scale.default <- function(x, center = TRUE, scale = TRUE)
{
    x <- as.matrix(x)
    nc <- ncol(x)
    if (is.logical(center)) {
	if (center) {
            center <- colMeans(x, na.rm=TRUE)
	    x <- sweep(x, 2L, center, check.margin=FALSE)
        }
    }
    else {
	if(!is.numeric(center)) center <- as.numeric(center)
	if (length(center) == nc)
	    x <- sweep(x, 2L, center, check.margin=FALSE)
	else
	    stop("length of 'center' must equal the number of columns of 'x'")
    }
    if (is.logical(scale)) {
	if (scale) {
	    f <- function(v) {
		v <- v[!is.na(v)]
		sqrt(sum(v^2) / max(1, length(v) - 1L))
	    }
            scale <- apply(x, 2L, f)
	    x <- sweep(x, 2L, scale, "/", check.margin=FALSE)
	}
    }
    else {
	if(!is.numeric(scale)) scale <- as.numeric(scale)
	if (length(scale) == nc)
	    x <- sweep(x, 2L, scale, "/", check.margin=FALSE)
	else
	    stop("length of 'scale' must equal the number of columns of 'x'")
    }
    if(is.numeric(center)) attr(x, "scaled:center") <- center
    if(is.numeric(scale )) attr(x, "scaled:scale" ) <- scale
    x
}
