% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anyMissing.R
\name{anyMissing}
\alias{anyMissing}
\alias{is.missing}
\title{Find missing values}
\usage{
anyMissing(x)

is.missing(x)
}
\arguments{
\item{x}{Vector or array of atomic values.}
}
\value{
For \code{anyMissing}, a logical scalar indicating whether any \code{NA} values were present in \code{x}.

For \code{is.missing}, a logical vector or array of shape equal to \code{x}, indicating whether each value is \code{NA}.
}
\description{
Find missing (\code{NA}) values.
This is smart enough to distinguish them from NaN values in numeric \code{x}.
For all other types, it just calls \code{\link{is.na}} or \code{\link{anyNA}}.
}
\examples{
anyNA(c(NaN))
anyNA(c(NA))
anyMissing(c(NaN))
anyMissing(c(NA))

is.na(c(NA, NaN))
is.missing(c(NA, NaN))
}
\author{
Aaron Lun
}
