% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listObjects.R
\name{listObjects}
\alias{listObjects}
\alias{listLocalObjects}
\alias{listDirectory}
\title{List objects in a directory}
\usage{
listObjects(dir, include.children = FALSE)
}
\arguments{
\item{dir}{String containing a path to a staging directory.}

\item{include.children}{Logical scalar indicating whether to include child objects.}
}
\value{
\linkS4class{DataFrame} where each row corresponds to an object and contains;
\itemize{
\item \code{path}, the relative path to the object's subdirectory inside \code{dir}.
\item \code{type}, the type of the object
\item \code{child}, whether or not the object is a child of another object.
}

If \code{include.children=FALSE}, metadata is only returned for non-child objects.
}
\description{
List all objects in a directory, along with their types.
}
\examples{
tmp <- tempfile()
dir.create(tmp)

library(S4Vectors)
df <- DataFrame(A=1:10, B=LETTERS[1:10])
saveObject(df, file.path(tmp, "whee"))

ll <- list(A=1, B=LETTERS, C=DataFrame(X=1:5))
saveObject(ll, file.path(tmp, "stuff"))

listObjects(tmp)
listObjects(tmp, include.children=TRUE)

}
\author{
Aaron Lun
}
