% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realizeFileBackedMatrix.R
\name{realizeFileBackedMatrix}
\alias{realizeFileBackedMatrix}
\alias{isFileBackedMatrix}
\title{Realize a file-backed DelayedMatrix}
\usage{
realizeFileBackedMatrix(x)

isFileBackedMatrix(x)
}
\arguments{
\item{x}{A \linkS4class{DelayedMatrix} object.}
}
\value{
For \code{realizeFileBackedMatrix}, an ordinary matrix or a \linkS4class{dgCMatrix}, depending on whether \code{\link{is_sparse}(x)}.

For \code{isFileBackedMatrix}, a logical scalar indicating whether \code{x} has file-backed components.
}
\description{
Realize a file-backed DelayedMatrix into its corresponding in-memory format.
}
\details{
A file-backed matrix representation is recognized based on whether it has a \code{\link{path}} method for any one of its seeds. 
If so, and the \code{"beachmat.realizeFileBackedMatrix"} option is not \code{FALSE}, we will load it into memory.
This is intended for DelayedMatrix objects that have already been subsetted (e.g., to highly variable genes),
which can be feasibly loaded into memory for rapid calculations.
}
\examples{
mat <- matrix(rnorm(50), ncol=5)
realizeFileBackedMatrix(mat) # no effect

library(HDF5Array)
mat2 <- as(mat, "HDF5Array")
realizeFileBackedMatrix(mat2) # realized into memory

}
\author{
Aaron Lun
}
