% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HnswParam-class.R
\docType{class}
\name{HnswParam}
\alias{HnswParam}
\alias{HnswParam-class}
\alias{show,HnswParam-method}
\alias{HnswParam_nlinks}
\alias{HnswParam_ef_construction}
\alias{HnswParam_directory}
\alias{HnswParam_ef_search}
\alias{[[,HnswParam-method}
\alias{[[<-,HnswParam-method}
\title{The HnswParam class}
\usage{
HnswParam(
  nlinks = 16,
  ef.construction = 200,
  directory = tempdir(),
  ef.search = 10,
  distance = "Euclidean"
)
}
\arguments{
\item{nlinks}{Integer scalar, number of bi-directional links per element for index generation.}

\item{ef.construction}{Integer scalar, size of the dynamic list for index generation.}

\item{directory}{String specifying the directory in which to save the index.}

\item{ef.search}{Integer scalar, size of the dynamic list for neighbor searching.}

\item{distance}{A string specifying the distance metric to use.}
}
\value{
An instance of the HnswParam class.
}
\description{
A class to hold parameters for the Hnsw algorithm for approximate nearest neighbor identification.
}
\details{
The HnswParam class holds any parameters associated with running the HNSW algorithm.
This generally relates to building of the index - see \code{\link{buildHnsw}} for details.

Users can get or set values with the usual \code{[[} syntax.
All parameters listed in the constructor can be manipulated in this manner.
}
\examples{
(out <- HnswParam())
out[['nlinks']]

out[['nlinks']] <- 20L
out

}
\seealso{
\code{\link{buildHnsw}}, for the index construction.

\code{\link{findHnsw}} and related functions, for the actual search. 

\linkS4class{BiocNeighborParam}, for the parent class and its available methods.
}
\author{
Aaron Lun
}
