% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chimeras.R
\name{removeBimeraDenovo}
\alias{removeBimeraDenovo}
\title{Remove bimeras from collections of unique sequences.}
\usage{
removeBimeraDenovo(unqs, method = "consensus", ..., verbose = FALSE)
}
\arguments{
\item{unqs}{(Required). A \code{\link{uniques-vector}} or any object that can be coerced
into one with \code{\link{getUniques}}. A list of such objects can also be provided.}

\item{method}{(Optional). Default is "consensus". Only has an effect if a sequence table is provided.

  If "pooled": The samples in the sequence table are all pooled together for bimera
     identification (\code{\link{isBimeraDenovo}}).   
     
  If "consensus": The samples in a sequence table are independently checked for bimeras,
     and a consensus decision on each sequence variant is made (\code{\link{isBimeraDenovoTable}}).

  If "per-sample": The samples in a sequence table are independently checked for bimeras,
     and sequence variants are removed (zeroed-out) from samples independently (\code{\link{isBimeraDenovo}}).}

\item{...}{(Optional). Arguments to be passed to \code{\link{isBimeraDenovo}} or \code{\link{isBimeraDenovoTable}}.
The documentation of those methods detail the additional algorithmic parameters that can be adjusted.}

\item{verbose}{(Optional). Default FALSE. 
Print verbose text output.}
}
\value{
A uniques vector, or an object of matching class if a data.frame or sequence table is provided.
 A list of such objects is returned if a list of input unqs was provided.
}
\description{
This function is a convenience interface for chimera removal. Two methods to identify chimeras are
 supported: Identification from pooled sequences (see \code{\link{isBimeraDenovo}} for details)
 and identification by consensus across samples (see \code{\link{isBimeraDenovoTable}} for details).
 Sequence variants identified as bimeric are removed, and a bimera-free collection of unique sequences
 is returned.
}
\examples{
derep1 = derepFastq(system.file("extdata", "sam1F.fastq.gz", package="dada2"))
dada1 <- dada(derep1, err=tperr1, errorEstimationFunction=loessErrfun, selfConsist=TRUE)
out.nobim <- removeBimeraDenovo(dada1)
out.nobim <- removeBimeraDenovo(dada1$clustering, method="pooled", minFoldParentOverAbundance = 2)

}
\seealso{
\code{\link{isBimeraDenovoTable}}, \code{\link{isBimeraDenovo}}
}
