## ----knitr, echo=FALSE, results="hide"----------------------------------------
library("knitr")
opts_chunk$set(tidy=FALSE,dev="png",fig.show="hide",
               fig.width=4,fig.height=4.5,
               message=FALSE)

## ----style-knitr, eval=TRUE, echo=FALSE, results="asis"--------------------
BiocStyle::latex()

## --------------------------------------------------------------------------
library("lpsymphony")

## --------------------------------------------------------------------------
obj <- c(3, 1, 3)

## --------------------------------------------------------------------------
mat <- matrix(c(-1, 0, 1, 2, 4, -3, 1, -3, 2), nrow = 3)
# mat <- matrix(c(-1,2,1,0,4,-3,1,-3,2), nrow = 3)

## --------------------------------------------------------------------------
dir <- c("<=", "<=", "<=")

## --------------------------------------------------------------------------
rhs <- c(4, 2, 3)

## --------------------------------------------------------------------------
max <- TRUE

## --------------------------------------------------------------------------
types <- c("I", "C", "I")

## --------------------------------------------------------------------------
lpsymphony_solve_LP(obj, mat, dir, rhs, types = types, max = max)

## --------------------------------------------------------------------------
bounds <- list(lower = list(ind = c(1,2,3), val = c(1,1,1)),
               upper = list(ind = c(1,2,3), val = c(5,5,5)))

## --------------------------------------------------------------------------
types <- c("C", "C", "C")
lpsymphony_solve_LP(obj, mat, dir, rhs, types = types, max = max, bounds = bounds)

## --------------------------------------------------------------------------
types <- c("I", "I", "I")
lpsymphony_solve_LP(obj, mat, dir, rhs, types = types, max = max, bounds = bounds)

## --------------------------------------------------------------------------
obj_dual <- rhs # rhs fom the Quick Start example

## --------------------------------------------------------------------------
mat_dual <- t(mat) # mat from the Quick Start example

## --------------------------------------------------------------------------
rhs_dual <- obj

## --------------------------------------------------------------------------
dir_dual <- c(">=", ">=", ">=")

## --------------------------------------------------------------------------
max_dual <- FALSE

## --------------------------------------------------------------------------
lpsymphony_solve_LP(obj_dual, mat_dual, dir_dual, rhs_dual, types = c("I","C","I"), max = max_dual)

