% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentationGATK4.R
\name{segmentationGATK4}
\alias{segmentationGATK4}
\title{GATK4 ModelSegments segmentation function}
\usage{
segmentationGATK4(
  normal,
  tumor,
  log.ratio,
  seg,
  vcf = NULL,
  tumor.id.in.vcf = 1,
  normal.id.in.vcf = NULL,
  min.logr.sdev = 0.15,
  prune.hclust.h = NULL,
  prune.hclust.method = NULL,
  changepoints.penality = NULL,
  additional.cmd.args = "",
  chr.hash = NULL,
  ...
)
}
\arguments{
\item{normal}{Coverage data for normal sample. Ignored in this function.}

\item{tumor}{Coverage data for tumor sample.}

\item{log.ratio}{Copy number log-ratios, one for each exon in coverage file.}

\item{seg}{If segmentation was provided by the user, this data structure
will contain this segmentation. Useful for minimal segmentation functions.
Otherwise PureCN will re-segment the data. This segmentation function
ignores this user provided segmentation.}

\item{vcf}{Optional \code{CollapsedVCF} object with germline allelic ratios.}

\item{tumor.id.in.vcf}{Id of tumor in case multiple samples are stored in
VCF.}

\item{normal.id.in.vcf}{Id of normal in in VCF. Currently not used.}

\item{min.logr.sdev}{Minimum log-ratio standard deviation used in the
model. Useful to make fitting more robust to outliers in very clean
data.}

\item{prune.hclust.h}{Ignored in this function.}

\item{prune.hclust.method}{Ignored in this function.}

\item{changepoints.penality}{The \code{--number-of-changepoints-penalty-factor}.
If \code{NULL}, find a sensible default. Ignored when provided in 
\code{additional.cmd.args}.}

\item{additional.cmd.args}{\code{character(1)}. By default,
\code{ModelSegments} is called with default parameters. Provide additional 
arguments here.}

\item{chr.hash}{Not needed here since \code{ModelSegments} does not
require numbered chromosome names.}

\item{...}{Currently unused arguments provided to other segmentation
functions.}
}
\value{
\code{data.frame} containing the segmentation.
}
\description{
A wrapper for GATK4s ModelSegmentation function, useful when normalization
is performed with other tools than GATK4, for example PureCN.
This function is called via the
\code{fun.segmentation} argument of \code{\link{runAbsoluteCN}}.  The
arguments are passed via \code{args.segmentation}.
}
\examples{

normal.coverage.file <- system.file("extdata", "example_normal_tiny.txt", 
    package="PureCN")
tumor.coverage.file <- system.file("extdata", "example_tumor_tiny.txt", 
    package="PureCN")
vcf.file <- system.file("extdata", "example.vcf.gz",
    package="PureCN")

# The max.candidate.solutions, max.ploidy and test.purity parameters are set to
# non-default values to speed-up this example.  This is not a good idea for real
# samples.
\dontrun{
 ret <-runAbsoluteCN(normal.coverage.file=normal.coverage.file, 
     tumor.coverage.file=tumor.coverage.file, vcf.file=vcf.file, 
     sampleid="Sample1",  genome="hg19",
     fun.segmentation = segmentationGATK4, max.ploidy=4,
     args.segmentation = list(additional.cmd.args = "--gcs-max-retries 19"),
     test.purity=seq(0.3,0.7,by=0.05), max.candidate.solutions=1)
}

}
\seealso{
\code{\link{runAbsoluteCN}}
}
\author{
Markus Riester
}
