% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwm.R
\name{motifIC}
\alias{motifIC}
\title{Information content for a PWM or PFM}
\usage{
motifIC(
  motif,
  prior.params = c(A = 0.25, C = 0.25, G = 0.25, T = 0.25),
  bycol = FALSE
)
}
\arguments{
\item{motif}{a matrix of frequencies, or a PWM object}

\item{prior.params}{the prior parameters to use when a matrix is given (ignored if motif is already a PWM)}

\item{bycol}{if to return values separately for each column}
}
\value{
information content in bits (i.e. log2)
}
\description{
Information content for a PWM or PFM
}
\examples{

if(requireNamespace("PWMEnrich.Dmelanogaster.background")){
   data(MotifDb.Dmel, package = "PWMEnrich.Dmelanogaster.background")
   data(MotifDb.Dmel.PFM, package = "PWMEnrich.Dmelanogaster.background")

   # the nucleotide distribution is taken from the PWM (in this case genomic background)
   motifIC(MotifDb.Dmel[["ttk"]]) 
   # information content with default uniform background because the input is a matrix, 
   # not PWM object
   motifIC(MotifDb.Dmel.PFM[["ttk"]]) 
}
}
