% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot_qvalue.R
\name{plot.qvalue}
\alias{plot,}
\alias{plot.qvalue}
\title{Plotting function for q-value object}
\usage{
\method{plot}{qvalue}(x, rng = c(0, 0.1), ...)
}
\arguments{
\item{x}{A q-value object.}

\item{rng}{Range of q-values to show. Optional}

\item{\ldots}{Additional arguments. Currently unused.}
}
\value{
Nothing of interest.
}
\description{
Graphical display of the q-value object
}
\details{
The function plot allows one to view several plots:
\enumerate{
 \item The estimated \eqn{\pi_0}{pi_0} versus the tuning parameter
 \eqn{\lambda}{lambda}.
 \item The q-values versus the p-values.
 \item The number of significant tests versus each q-value cutoff.
 \item The number of expected false positives versus the number of
 significant tests.
 }

This function makes four plots. The first is a plot of the
estimate of \eqn{\pi_0}{pi_0} versus its tuning parameter
\eqn{\lambda}{lambda}. In most cases, as \eqn{\lambda}{lambda}
gets larger, the bias of the estimate decreases, yet the variance
increases. Various methods exist for balancing this bias-variance
trade-off (Storey 2002, Storey & Tibshirani 2003, Storey, Taylor
& Siegmund 2004). Comparing your estimate of \eqn{\pi_0}{pi_0} to this
plot allows one to guage its quality. The remaining three plots
show how many tests are called significant and how many false
positives to expect for each q-value cut-off. A thorough discussion of
these plots can be found in Storey & Tibshirani (2003).
}
\examples{
# import data
data(hedenfalk)
p <- hedenfalk$p
qobj <- qvalue(p)

plot(qobj, rng=c(0.0, 0.3))
}
\author{
John D. Storey, Andrew J. Bass
}
\references{
Storey JD. (2002) A direct approach to false discovery rates. Journal
of the Royal Statistical Society, Series B, 64: 479-498. \cr
\url{http://onlinelibrary.wiley.com/doi/10.1111/1467-9868.00346/abstract}

Storey JD and Tibshirani R. (2003) Statistical significance for
genome-wide experiments. Proceedings of the National Academy of Sciences,
100: 9440-9445. \cr
\url{http://www.pnas.org/content/100/16/9440.full}

Storey JD. (2003) The positive false discovery rate: A Bayesian
interpretation and the q-value. Annals of Statistics, 31: 2013-2035. \cr
\url{http://projecteuclid.org/DPubS/Repository/1.0/Disseminate?view=body&id=pdf_1&handle=euclid.aos/1074290335}

Storey JD, Taylor JE, and Siegmund D. (2004) Strong control,
conservative point estimation, and simultaneous conservative
consistency of false discovery rates: A unified approach. Journal of
the Royal Statistical Society, Series B, 66: 187-205. \cr

Storey JD. (2011) False discovery rates. In \emph{International Encyclopedia of Statistical Science}. \cr
\url{http://genomine.org/papers/Storey_FDR_2011.pdf} \cr
\url{http://www.springer.com/statistics/book/978-3-642-04897-5}
}
\seealso{
\code{\link{qvalue}}, \code{\link{write.qvalue}}, \code{\link{summary.qvalue}}
}
\keyword{plot}

