% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/423-extractProtPSSMAcc.R
\name{extractProtPSSMAcc}
\alias{extractProtPSSMAcc}
\title{Profile-based protein representation derived by PSSM
(Position-Specific Scoring Matrix) and auto cross covariance}
\usage{
extractProtPSSMAcc(pssmmat, lag)
}
\arguments{
\item{pssmmat}{The PSSM computed by \code{\link{extractProtPSSM}}.}

\item{lag}{The lag parameter. Must be less than the number of amino acids
in the sequence (i.e. the number of columns in the PSSM matrix).}
}
\value{
A length \code{lag * 20^2} named numeric vector,
the element names are derived by the amino acid name abbreviation
(crossed amino acid name abbreviation) and lag index.
}
\description{
Profile-based protein representation derived by PSSM
(Position-Specific Scoring Matrix) and auto cross covariance
}
\details{
This function calculates the feature vector based on the PSSM
by running PSI-Blast and auto cross covariance tranformation.
}
\examples{
x = readFASTA(system.file('protseq/P00750.fasta', package = 'Rcpi'))[[1]]
\donttest{
dbpath = tempfile('tempdb', fileext = '.fasta')
invisible(file.copy(from = system.file('protseq/Plasminogen.fasta', package = 'Rcpi'), to = dbpath))
pssmmat = extractProtPSSM(seq = x, database.path = dbpath)
pssmacc = extractProtPSSMAcc(pssmmat, lag = 3)
tail(pssmacc)}
}
\references{
Wold, S., Jonsson, J., Sjörström, M., Sandberg, M., & Rännar, S. (1993).
DNA and peptide sequences and chemical processes multivariately modelled
by principal component analysis and partial least-squares projections
to latent structures.
\emph{Analytica chimica acta}, 277(2), 239--253.
}
\seealso{
\link{extractProtPSSM} \link{extractProtPSSMFeature}
}
