% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cwlWorkflow.R
\name{cwlWorkflow}
\alias{cwlWorkflow}
\alias{+,cwlWorkflow,cwlStep-method}
\alias{steps}
\alias{steps<-}
\title{cwlWorkflow function}
\usage{
cwlWorkflow(
  cwlVersion = "v1.0",
  cwlClass = "Workflow",
  requirements = list(),
  id = character(),
  label = character(),
  doc = character(),
  intent = list(),
  hints = list(),
  arguments = list(),
  extensions = list(),
  inputs = InputParamList(),
  outputs = OutputParamList(),
  steps = cwlStepList()
)

\S4method{+}{cwlWorkflow,cwlStep}(e1, e2)

steps(cwl)

steps(cwl) <- value
}
\arguments{
\item{cwlVersion}{CWL version}

\item{cwlClass}{"Workflow".}

\item{requirements}{Requirements that apply to either the runtime
environment or the workflow engine.}

\item{id}{A user-defined unique identifier for this workflow.}

\item{label}{A short, human-readable label of this object.}

\item{doc}{A documentation string for this object.}

\item{intent}{An identifier for the type of computational
operation, of this Process.}

\item{hints}{Any or a list for the workflow engine.}

\item{arguments}{Command line bindings which are not directly
associated with input parameters.}

\item{extensions}{A list of extensions and metadata.}

\item{inputs}{An object of `InputParamList`.}

\item{outputs}{An object of `OutputParamList`.}

\item{steps}{A list of `cwlStepList`.}

\item{e1}{A `cwlWorkflow` object.}

\item{e2}{A `cwlStep` object.}

\item{cwl}{A `cwlWorkflow` object.}

\item{value}{A list of `cwlSteps` to assign.}
}
\value{
cwlWorkflow: An object of class `cwlWorkflow`.

steps: A list of `cwlStep` objects.
}
\description{
The constructor function for `cwlWorkflow` object,
    which connects multiple command line steps into a workflow.

steps: Function to extract and assign workflow step
    slots.
}
\examples{
input1 <- InputParam(id = "sth")
echo1 <- cwlProcess(baseCommand = "echo",
                  inputs = InputParamList(input1))
input2 <- InputParam(id = "sthout", type = "File")
echo2 <- cwlProcess(baseCommand = "echo",
                  inputs = InputParamList(input2),
                  stdout = "out.txt")
i1 <- InputParam(id = "sth")
o1 <- OutputParam(id = "out", type = "File", outputSource = "echo2/output")
wf <- cwlWorkflow(inputs = InputParamList(i1),
                   outputs = OutputParamList(o1))
s1 <- cwlStep(id = "echo1", run = echo1, In = list(sth = "sth"))
s2 <- cwlStep(id = "echo2", run = echo2, In = list(sthout = "echo1/output"))
wf <- wf + s1 + s2
}
\seealso{
\code{\link{stepInParamList}}
}
