% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/satuRn-framework.R
\name{StatModel}
\alias{StatModel}
\title{StatModel}
\usage{
StatModel(
  type = "fitError",
  params = list(),
  varPosterior = NA_real_,
  dfPosterior = NA_real_
)
}
\arguments{
\item{type}{default set to fiterror, can be a glm}

\item{params}{A list containing the parameters of the fitted glm}

\item{varPosterior}{Numeric, posterior variance of the glm, default is NA}

\item{dfPosterior}{Numeric, posterior degrees of freedom of the glm, 
default is NA}
}
\value{
A StatModel object
}
\description{
Function for contstructing a new `StatModel` object.
}
\examples{
## A fully specified dummy model
myModel <- StatModel(
    type = "glm",
    params = list(x = 3, y = 7, b = 4),
    varPosterior = c(0.1, 0.2, 0.3),
    dfPosterior = c(6, 7, 8)
)
myModel
}
