% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHighestExprs.R
\name{plotHighestExprs}
\alias{plotHighestExprs}
\title{Plot the highest expressing features}
\usage{
plotHighestExprs(
  object,
  n = 50,
  colour_cells_by = color_cells_by,
  drop_features = NULL,
  exprs_values = "counts",
  by_exprs_values = exprs_values,
  feature_names_to_plot = NULL,
  as_percentage = TRUE,
  swap_rownames = NULL,
  color_cells_by = NULL,
  assay.type = exprs_values,
  by.assay.type = by_exprs_values
)
}
\arguments{
\item{object}{A SingleCellExperiment object.}

\item{n}{A numeric scalar specifying the number of the most expressed features to show.}

\item{colour_cells_by}{Specification of a column metadata field or a feature to colour by, see \code{?\link{retrieveCellInfo}} for possible values.}

\item{drop_features}{A character, logical or numeric vector indicating which features (e.g. genes, transcripts) to drop when producing the plot. 
For example, spike-in transcripts might be dropped to examine the contribution from endogenous genes.}

\item{exprs_values}{Alias to \code{assay.type}.}

\item{by_exprs_values}{Alias to \code{by.assay.type}.}

\item{feature_names_to_plot}{String specifying which row-level metadata column contains the feature names.
Alternatively, an \link{AsIs}-wrapped vector or a data.frame, see \code{?\link{retrieveFeatureInfo}} for possible values.
Default is \code{NULL}, in which case \code{rownames(object)} are used.}

\item{as_percentage}{logical scalar indicating whether percentages should be  plotted. 
If \code{FALSE}, the raw \code{assay.type} are shown instead.}

\item{swap_rownames}{Column name of \code{rowData(object)} to be used to 
identify features instead of \code{rownames(object)} when labelling plot 
elements.}

\item{color_cells_by}{Alias to \code{colour_cells_by}.}

\item{assay.type}{A integer scalar or string specifying the assay to obtain expression values from.}

\item{by.assay.type}{A string or integer scalar specifying which assay to obtain expression values from, 
for use in colouring - see \code{?\link{retrieveCellInfo}} for details.}
}
\value{
A \link{ggplot} object.
}
\description{
Plot the features with the highest average expression across all cells, along with their expression in each individual cell.
}
\details{
This function will plot the percentage of counts accounted for by the top \code{n} most highly expressed features across the dataset.
Each row on the plot corresponds to a feature and is sorted by average expression (denoted by the point).
The distribution of expression across all cells is shown as tick marks for each feature.
These ticks can be coloured according to cell-level metadata, as specified by \code{colour_cells_by}.
}
\examples{
example_sce <- mockSCE()
colData(example_sce) <- cbind(colData(example_sce),
     perCellQCMetrics(example_sce))

plotHighestExprs(example_sce, colour_cells_by="detected")
plotHighestExprs(example_sce, colour_cells_by="Mutation_Status")

}
