% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LaMannoBrainData.R
\name{LaMannoBrainData}
\alias{LaMannoBrainData}
\title{Obtain the La Manno brain data}
\usage{
LaMannoBrainData(
  which = c("human-es", "human-embryo", "human-ips", "mouse-adult", "mouse-embryo"),
  ensembl = FALSE,
  location = TRUE
)
}
\arguments{
\item{which}{A string specifying which dataset should be obtained.}

\item{ensembl}{Logical scalar indicating whether the output row names should contain Ensembl identifiers.}

\item{location}{Logical scalar indicating whether genomic coordinates should be returned.}
}
\value{
A \linkS4class{SingleCellExperiment} object with a single matrix of UMI counts.
}
\description{
Obtain the mouse/human brain scRNA-seq data from La Manno et al. (2016).
}
\details{
Column metadata is provided in the same form as supplied in the supplementary tables in GSE71585.
This contains information such as the time point and cell type.

The various settings of \code{which} will obtain different data sets.
\itemize{
\item \code{"human-es"}, human embryonic stem cells.
\item \code{"human-embryo"}, human embryo midbrain.
\item \code{"human-ips"}, human induced pluripotent stem cells.
\item \code{"mouse-adult"}, mouse adult dopaminergic neurons.
\item \code{"mouse-embryo"}, mouse embryo midbrain.
}
Unfortunately, each of these datasets uses a different set of features.
If multiple datasets are to be used simultaneously, users will have to decide how to merge them,
e.g., by taking the intersection of common features across all datasets.

If \code{ensembl=TRUE}, the gene symbols are converted to Ensembl IDs in the row names of the output object.
Rows with missing Ensembl IDs are discarded, and only the first occurrence of duplicated IDs is retained.

If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link{rowRanges}} of the output.
Note that this is only performed if \code{ensembl=TRUE}.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/lamanno-brain}.
}
\examples{
sce.h.es <- LaMannoBrainData()

sce.h.em <- LaMannoBrainData("human-embryo")

sce.h.ip <- LaMannoBrainData("human-ips")

sce.m.ad <- LaMannoBrainData("mouse-adult")

sce.m.em <- LaMannoBrainData("mouse-embryo")

}
\references{
La Manno A et al. (2016).
Molecular diversity of midbrain development in mouse, human, and stem cells. 
\emph{Cell} 167(2), 566-580.
}
\author{
Aaron Lun
}
