% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZeiselNervousData.R
\name{ZeiselNervousData}
\alias{ZeiselNervousData}
\title{Obtain the Zeisel nervous system data}
\usage{
ZeiselNervousData(location = TRUE)
}
\arguments{
\item{location}{Logical scalar indicating whether genomic coordinates should be returned.}
}
\value{
A \linkS4class{SingleCellExperiment} object with a single matrix of UMI counts.
}
\description{
Obtain the mouse nervous system single-cell RNA-seq dataset from Zeisel et al. (2018).
}
\details{
Row data contains the gene symbol as well as some relevant per-gene statistics,
e.g., the squared coefficient of variance, mean, and whether it was selected for downstream analyses.

Column data contains a wide variety of fields including patient-level information, sample-level sequencing statistics and many flavors of cell type classification.
Note that many numeric columns may have \code{NA} values if they could not be successfully parsed form the source file.

If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link{rowRanges}} of the output.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/zeisel-nervous}.
}
\examples{
if (.Machine$sizeof.pointer > 4) { # too large for 32-bit machines!
    sce <- ZeiselNervousData()
}
}
\references{
Zeisel A et al. (2018). 
Molecular architecture of the mouse nervous system.
\emph{Cell} 174(4), 999-1014.
}
\author{
Aaron Lun
}
