% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMarkerHeatmap.R
\name{plotMarkerHeatmap}
\alias{plotMarkerHeatmap}
\title{Plot a heatmap of the markers for a label}
\usage{
plotMarkerHeatmap(
  results,
  test,
  label,
  other.labels = NULL,
  assay.type = "logcounts",
  display.row.names = NULL,
  use.pruned = FALSE,
  order.by = "rank.logFC.cohen",
  top = 20,
  BPPARAM = SerialParam()
)
}
\arguments{
\item{results}{A \linkS4class{DataFrame} containing the output from \code{\link{SingleR}},
\code{\link{classifySingleR}}, \code{\link{combineCommonResults}}, or \code{\link{combineRecomputedResults}}.}

\item{test}{A numeric matrix of log-normalized expression values where rows are genes and columns are cells.
Each row should be named with the same gene name that was used to compute \code{results}.

Alternatively, a \linkS4class{SummarizedExperiment} object containing such a matrix.}

\item{label}{String specifying the label of interest.}

\item{other.labels}{Character vector specifying the other labels to be compared to \code{label} when finding interesting markers.
Defaults to all available labels.}

\item{assay.type}{Integer scalar or string specifying the matrix of expression values to use if \code{test} is a \linkS4class{SummarizedExperiment}.}

\item{display.row.names}{Character vector of length equal to the number of rows of \code{test},
containing the names of the features to show on the heatmap (e.g., to replace IDs with symbols).
If \code{NULL}, the existing row names of \code{test} are used.}

\item{use.pruned}{Logical scalar indicating whether the pruned labels should be used instead.}

\item{order.by}{String specifying the column of the output of \code{\link[scran]{scoreMarkers}} with which to sort for interesting markers.}

\item{top}{Integer scalar indicating the top most interesting markers to show in the heatmap.}

\item{BPPARAM}{A \linkS4class{BiocParallelParam} object specifying the parallelization scheme to use for marker scoring.}
}
\value{
The output of \code{\link[pheatmap]{pheatmap}} is returned showing the heatmap on the current graphics device.
}
\description{
Create a heatmap of the log-normalized expression for the most interesting markers of a particular label.
}
\details{
This function creates a heatmap where each row is a marker gene for \code{label} and each column is a cell in the test dataset.
The aim is to check the effectiveness of the reference-derived markers for distinguishing between labels in the test dataset.
Useful markers from the reference should show strong upregulation in \code{label} compared to all \code{other.labels}. 
We identify such markers by scoring all reference-derived markers with \code{\link[scran]{scoreMarkers}} on the \code{test} expression.
The \code{top} markers based on the specified \code{order.by} field are shown in the heatmap.
If only one label is present, markers are ranked by average abundance intead.
}
\examples{
# Running the SingleR() example.
example(SingleR, echo=FALSE)

plotMarkerHeatmap(pred, test, pred$labels[1])
plotMarkerHeatmap(pred, test, pred$labels[1], use.pruned=TRUE)
plotMarkerHeatmap(pred, test, pred$labels[1], order.by="rank.AUC")

}
\author{
Aaron Lun
}
