% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{TCGAvisualize_oncoprint}
\alias{TCGAvisualize_oncoprint}
\title{Creating a oncoprint}
\usage{
TCGAvisualize_oncoprint(
  mut,
  genes,
  filename,
  color,
  annotation.position = "bottom",
  annotation,
  height,
  width = 10,
  rm.empty.columns = FALSE,
  show.column.names = FALSE,
  show.row.barplot = TRUE,
  label.title = "Mutation",
  column.names.size = 8,
  label.font.size = 16,
  rows.font.size = 16,
  dist.col = 0.5,
  dist.row = 0.5,
  information = "Variant_Type",
  row.order = TRUE,
  col.order = TRUE,
  heatmap.legend.side = "bottom",
  annotation.legend.side = "bottom"
)
}
\arguments{
\item{mut}{A dataframe from the mutation annotation file (see TCGAquery_maf from TCGAbiolinks)}

\item{genes}{Gene list}

\item{filename}{name of the pdf}

\item{color}{named vector for the plot}

\item{annotation.position}{Position of the annotation "bottom" or "top"}

\item{annotation}{Matrix or data frame with the annotation.
Should have a column bcr_patient_barcode with the same ID of the mutation object}

\item{height}{pdf height}

\item{width}{pdf width}

\item{rm.empty.columns}{If there is no alteration in that sample, whether remove it on the oncoprint}

\item{show.column.names}{Show column names? Default: FALSE}

\item{show.row.barplot}{Show barplot annotation on rows?}

\item{label.title}{Title of the label}

\item{column.names.size}{Size of the fonts of the columns names}

\item{label.font.size}{Size of the fonts}

\item{rows.font.size}{Size of the fonts}

\item{dist.col}{distance between columns in the plot}

\item{dist.row}{distance between rows in the plot}

\item{information}{Which column to use as information from MAF.
Options: 1) "Variant_Classification" (The information will be "Frame_Shift_Del", "Frame_Shift_Ins",
        "In_Frame_Del", "In_Frame_Ins", "Missense_Mutation",  "Nonsense_Mutation",
             "Nonstop_Mutation",  "RNA",  "Silent" ,  "Splice_Site",  "Targeted_Region",  "Translation_Start_Site")
2) "Variant_Type" (The information will be INS,DEL,SNP)}

\item{row.order}{Order the genes (rows) Default:TRUE. Genes with more mutations will be in the first rows}

\item{col.order}{Order columns. Default:TRUE.}

\item{heatmap.legend.side}{Position of the heatmap legend}

\item{annotation.legend.side}{Position of the annotation legend}
}
\value{
A oncoprint plot
}
\description{
Creating a oncoprint
}
\examples{
\dontrun{
library(dplyr)
query <- GDCquery(
   project = "TCGA-CHOL",
   data.category = "Simple Nucleotide Variation",
   access = "open",
   legacy = FALSE,
   data.type = "Masked Somatic Mutation",
   workflow.type = "Aliquot Ensemble Somatic Variant Merging and Masking"
)
GDCdownload(query)
mut <- GDCprepare(query)
TCGAvisualize_oncoprint(mut = mut, genes = mut$Hugo_Symbol[1:10], rm.empty.columns = TRUE)
TCGAvisualize_oncoprint(
  mut = mut, genes = mut$Hugo_Symbol[1:10],
  filename = "onco.pdf",
  color = c("background"="#CCCCCC","DEL"="purple","INS"="yellow","SNP"="brown")
)
clin <- GDCquery_clinic("TCGA-ACC","clinical")
clin <- clin[,c("bcr_patient_barcode","disease","gender","tumor_stage","race","vital_status")]
TCGAvisualize_oncoprint(
   mut = mut, genes = mut$Hugo_Symbol[1:20],
   filename = "onco.pdf",
   annotation = clin,
   color=c("background"="#CCCCCC","DEL"="purple","INS"="yellow","SNP"="brown"),
   rows.font.size=10,
   heatmap.legend.side = "right",
   dist.col = 0,
   label.font.size = 10
)
}
}
