\name{searchPairBSgenome-methods}
\docType{methods}
\alias{searchPairBSgenome}
\alias{searchPairBSgenome-methods}
\alias{searchPairBSgenome,PWMatrix-method}
\alias{searchPairBSgenome,PWMatrixList-method}
\title{searchPairBSgenome method} 
\description{
  Given a chain file for liftover from one genome to another, 
  it searches two \code{BSgenome} with a \code{PWMatrix},
  and only reports the hits that are presents in two genomes 
  with equivalent positions. 
}

\usage{
  searchPairBSgenome(pwm, BSgenome1, BSgenome2, chr1, chr2,
                     min.score="80\%", strand="*", chain)
}

\arguments{
  \item{pwm}{
    A \link{PWMatrix} object or a \link{PWMatrixList} object.
  }
  \item{BSgenome1, BSgenome2}{
    A \code{BSgenome} class.
  }
  \item{chr1, chr2}{
    A \code{character} object, specifying the chromosomes you want to search. 
  }
  \item{min.score}{
    The minimum score for the hit. 
    Can be given an character string in th format
    of "80\%" or as a single absolute value.
  }
  \item{strand}{
    When searching the alignment, 
    we can search the positive "+" strand or negative "-" strand.
    While strand is "*", it will search both strands and
    return the results based on the positvie strand coordinate.
  }
  \item{chain}{
    A \code{Chain} object. 
    It can be generated by \code{import.chain} from package \code{rtracklayer}.
    Please provide the chain from BSgenome1 to BSgenome2.
  }
}

\value{
  A \code{SitePairSet} object is returned when pwm is a \code{PWMatrix},
  while a \code{SitePairSetList} is returned when pwm is a \code{PWMatrixList}.
}

\author{
  Ge Tan
}

\seealso{
  \code{\link{searchAln}}
}

\examples{
  \dontrun{
    library(rtracklayer)
    library(JASPAR2014)
    library(BSgenome.Hsapiens.UCSC.hg19)
    library(BSgenome.Mmusculus.UCSC.mm10)
    data("MA0004.1")
    pfm <- MA0004.1
    pwm <- toPWM(pfm)
    chain <- import.chain("Downloads/hg19ToMm10.over.chain")
    sitepairset <- searchPairBSgenome(pwm, BSgenome.Hsapiens.UCSC.hg19,
                                      BSgenome.Mmusculus.UCSC.mm10,
                                      chr1="chr1", chr2="chr1",
                                      min.score="90\%", strand="+", 
                                      chain=chain)
  }
}

\keyword{methods}

