% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_vep_api.R
\name{vep_by_region}
\alias{vep_by_region}
\title{Use the VEP region API on variant information in a VCF object as defined in VariantAnnotation.}
\usage{
vep_by_region(vcfobj, snv_only = TRUE, chk_max = TRUE)
}
\arguments{
\item{vcfobj}{instance of VCF class; note the difference between the CollapsedVCF and
ExpandedVCF instances.}

\item{snv_only}{logical(1) if TRUE filter the VCF to information about single nucleotide addresses}

\item{chk_max}{logical(1) requests to ensembl VEP API are limited to 200 positions; if
TRUE and the request involves more than 200 positions, an error is thrown by this function.}
}
\value{
instance of 'response' from httr package
}
\description{
Use the VEP region API on variant information in a VCF object as defined in VariantAnnotation.
}
\examples{
fl <- system.file("extdata", "chr22.vcf.gz", package="VariantAnnotation")
r22 = readVcf(fl)
dr = which(width(rowRanges(r22))!=1)
r22s = r22[-dr]
res = vep_by_region(r22[1:100], snv_only=FALSE, chk_max=FALSE)
ans = jsonlite::fromJSON(jsonlite::toJSON(httr::content(res)))
}
