% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_prior.R
\name{describe_prior}
\alias{describe_prior}
\title{Describe Priors}
\usage{
describe_prior(model, ...)
}
\arguments{
\item{model}{A Bayesian model.}

\item{...}{Currently not used.}
}
\description{
Returns a summary of the priors used in the model.
}
\examples{
\dontrun{
library(bayestestR)

# rstanarm models
# -----------------------------------------------
if (require("rstanarm")) {
  model <- rstanarm::stan_glm(mpg ~ wt + cyl, data = mtcars)
  describe_prior(model)
}

# brms models
# -----------------------------------------------
if (require("brms")) {
  model <- brms::brm(mpg ~ wt + cyl, data = mtcars)
  describe_prior(model)
}

# BayesFactor objects
# -----------------------------------------------
if (require("BayesFactor")) {
  bf <- ttestBF(x = rnorm(100, 1, 1))
  describe_prior(bf)
}
}
}
