% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sexit_thresholds.R
\name{sexit_thresholds}
\alias{sexit_thresholds}
\title{Find Effect Size Thresholds}
\usage{
sexit_thresholds(x, ...)
}
\arguments{
\item{x}{Vector representing a posterior distribution. Can also be a
\code{stanreg} or \code{brmsfit} model.}

\item{...}{Currently not used.}
}
\description{
This function attempts at automatically finding suitable default
values for a "significant" (i.e., non-negligible) and "large" effect. This is
to be used with care, and the chosen threshold should always be explicitly
reported and justified. See the detail section in \code{\link[=sexit]{sexit()}} for more
information.
}
\examples{
sexit_thresholds(rnorm(1000))
\donttest{
if (require("rstanarm")) {
  model <- suppressWarnings(stan_glm(
    mpg ~ wt + gear,
    data = mtcars,
    chains = 2,
    iter = 200,
    refresh = 0
  ))
  sexit_thresholds(model)

  model <- suppressWarnings(
    stan_glm(vs ~ mpg, data = mtcars, family = "binomial", refresh = 0)
  )
  sexit_thresholds(model)
}

if (require("brms")) {
  model <- brm(mpg ~ wt + cyl, data = mtcars)
  sexit_thresholds(model)
}

if (require("BayesFactor")) {
  bf <- ttestBF(x = rnorm(100, 1, 1))
  sexit_thresholds(bf)
}
}
}
\references{
Kruschke, J. K. (2018). Rejecting or accepting parameter values in Bayesian estimation. Advances in Methods and Practices in Psychological Science, 1(2), 270-280. \doi{10.1177/2515245918771304}.
}
