% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_outer.R
\name{variable.names.zlm}
\alias{variable.names.zlm}
\alias{vcov.zlm}
\alias{logLik.zlm}
\title{Variable names and design matrix}
\usage{
\method{variable.names}{zlm}(object, ...)
}
\arguments{
\item{object}{A \code{bma} object (as produced by \code{\link{bms}})}

\item{...}{further arguments passed to or from other methods}
}
\description{
Simple utilities retrieving variable names and design matrix from a bma
object
}
\details{
\code{variable.names.zlm}: method \code{\link{variable.names}} for a
\code{\link{zlm}} model. \cr \code{vcov.zlm}: the posterior
variance-covariance matrix of the coefficients of a \code{\link{zlm}} model
- cf. \code{\link{vcov}} \cr \code{logLik.zlm}: a \code{\link{zlm}} model's
log-likelihood \code{p(y|M)} according to the implementation of the
respective coefficent prior \cr
}
\examples{

 data(datafls)
  
 zz=zlm(datafls)
 variable.names(zz)
 vcov(zz)
 logLik(zz)
 
}
\seealso{
\code{\link{zlm}} for creating \code{zlm} objects

Check \url{http://bms.zeugner.eu} for additional help.
}
\keyword{utilities}
