% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_epred.R
\name{fitted.brmsfit}
\alias{fitted.brmsfit}
\title{Expected Values of the Posterior Predictive Distribution}
\usage{
\method{fitted}{brmsfit}(
  object,
  newdata = NULL,
  re_formula = NULL,
  scale = c("response", "linear"),
  resp = NULL,
  dpar = NULL,
  nlpar = NULL,
  ndraws = NULL,
  draw_ids = NULL,
  sort = FALSE,
  summary = TRUE,
  robust = FALSE,
  probs = c(0.025, 0.975),
  ...
)
}
\arguments{
\item{object}{An object of class \code{brmsfit}.}

\item{newdata}{An optional data.frame for which to evaluate predictions. If
\code{NULL} (default), the original data of the model is used.
\code{NA} values within factors are interpreted as if all dummy
variables of this factor are zero. This allows, for instance, to make
predictions of the grand mean when using sum coding.}

\item{re_formula}{formula containing group-level effects to be considered in
the prediction. If \code{NULL} (default), include all group-level effects;
if \code{NA}, include no group-level effects.}

\item{scale}{Either \code{"response"} or \code{"linear"}.
If \code{"response"}, results are returned on the scale
of the response variable. If \code{"linear"},
results are returned on the scale of the linear predictor term,
that is without applying the inverse link function or
other transformations.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{dpar}{Optional name of a predicted distributional parameter.
If specified, expected predictions of this parameters are returned.}

\item{nlpar}{Optional name of a predicted non-linear parameter.
If specified, expected predictions of this parameters are returned.}

\item{ndraws}{Positive integer indicating how many posterior draws should
be used. If \code{NULL} (the default) all draws are used. Ignored if
\code{draw_ids} is not \code{NULL}.}

\item{draw_ids}{An integer vector specifying the posterior draws to be used.
If \code{NULL} (the default), all draws are used.}

\item{sort}{Logical. Only relevant for time series models.
Indicating whether to return predicted values in the original
order (\code{FALSE}; default) or in the order of the
time series (\code{TRUE}).}

\item{summary}{Should summary statistics be returned
instead of the raw values? Default is \code{TRUE}..}

\item{robust}{If \code{FALSE} (the default) the mean is used as
the measure of central tendency and the standard deviation as
the measure of variability. If \code{TRUE}, the median and the
median absolute deviation (MAD) are applied instead.
Only used if \code{summary} is \code{TRUE}.}

\item{probs}{The percentiles to be computed by the \code{quantile}
function. Only used if \code{summary} is \code{TRUE}.}

\item{...}{Further arguments passed to \code{\link{prepare_predictions}}
that control several aspects of data validation and prediction.}
}
\value{
An \code{array} of predicted \emph{mean} response values.
  If \code{summary = FALSE} the output resembles those of
  \code{\link{posterior_epred.brmsfit}}.

  If \code{summary = TRUE} the output depends on the family: For categorical
  and ordinal families, the output is an N x E x C array, where N is the
  number of observations, E is the number of summary statistics, and C is the
  number of categories. For all other families, the output is an N x E
  matrix. The number of summary statistics E is equal to \code{2 +
  length(probs)}: The \code{Estimate} column contains point estimates (either
  mean or median depending on argument \code{robust}), while the
  \code{Est.Error} column contains uncertainty estimates (either standard
  deviation or median absolute deviation depending on argument
  \code{robust}). The remaining columns starting with \code{Q} contain
  quantile estimates as specified via argument \code{probs}.

  In multivariate models, an additional dimension is added to the output
  which indexes along the different response variables.
}
\description{
This method is an alias of \code{\link{posterior_epred.brmsfit}}
with additional arguments for obtaining summaries of the computed draws.
}
\examples{
\dontrun{
## fit a model
fit <- brm(rating ~ treat + period + carry + (1|subject),
           data = inhaler)

## compute expected predictions
fitted_values <- fitted(fit)
head(fitted_values)

## plot expected predictions against actual response
dat <- as.data.frame(cbind(Y = standata(fit)$Y, fitted_values))
ggplot(dat) + geom_point(aes(x = Estimate, y = Y))
}

}
\seealso{
\code{\link{posterior_epred.brmsfit}}
}
