% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-irlba.R
\name{tidy_irlba}
\alias{tidy_irlba}
\alias{tidy.irlba}
\alias{irlba_tidiers}
\title{Tidy a(n) irlba object masquerading as list}
\usage{
tidy_irlba(x, ...)
}
\arguments{
\item{x}{A list returned from \code{\link[irlba:irlba]{irlba::irlba()}}.}

\item{...}{
  Arguments passed on to \code{\link[=tidy_svd]{tidy_svd}}
  \describe{
    \item{\code{matrix}}{Character specifying which component of the PCA should be
tidied.
\itemize{
\item \code{"u"}, \code{"samples"}, or \code{"x"}: returns information about the map from
the original space into principle components space.
\item \code{"v"}, \code{"rotation"}, or \code{"variables"}: returns information about the
map from principle components space back into the original space.
\item \code{"d"} or \code{"pcs"}: returns information about the eigenvalues
will return information about
}}
  }}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with columns depending on the component of
PCA being tidied.

If \code{matrix} is \code{"u"}, \code{"samples"}, or \code{"x"} each row in the tidied
output corresponds to the original data in PCA space. The columns are:

\item{\code{row}}{ID of the original observation (i.e. rowname from original
data).}
\item{\code{PC}}{Integer indicating a principle component.}
\item{\code{value}}{The score of the observation for that particular principle
component. That is, the location of the observation in PCA space.}

If \code{matrix} is \code{"v"}, \code{"rotation"}, or \code{"variables"}, each row in the
tidied ouput corresponds to information about the principle components
in the original space. The columns are:

\item{\code{row}}{The variable labels (colnames) of the data set on
which PCA was performed}
\item{\code{PC}}{An integer vector indicating the principal component}
\item{\code{value}}{The value of the eigenvector (axis score) on the
indicated principal component}

If \code{matrix} is \code{"d"} or \code{"pcs"}, the columns are:

\item{\code{PC}}{An integer vector indicating the principal component}
\item{\code{std.dev}}{Standard deviation explained by this PC}
\item{\code{percent}}{Percentage of variation explained}
\item{\code{cumulative}}{Cumulative percentage of variation explained}
}
\description{
Broom tidies a number of lists that are effectively S3
objects without a class attribute. For example, \code{\link[stats:optim]{stats::optim()}},
\code{\link[=svd]{svd()}} and \code{\link[akima:interp]{akima::interp()}} produce consistent output, but because
they do not have a class attribute, they cannot be handled by S3 dispatch.

These functions look at the elements of a list and determine if there is
an appropriate tidying method to apply to the list. Those tidiers are
themselves are implemented as functions of the form \verb{tidy_<function>}
or \verb{glance_<function>} and are not exported (but they are documented!).

If no appropriate tidying method is found, throws an error.
}
\details{
A very thin wrapper around \code{\link[=tidy_svd]{tidy_svd()}}.
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[irlba:irlba]{irlba::irlba()}}

Other list tidiers: 
\code{\link{glance_optim}()},
\code{\link{list_tidiers}},
\code{\link{tidy_optim}()},
\code{\link{tidy_svd}()},
\code{\link{tidy_xyz}()}

Other svd tidiers: 
\code{\link{augment.prcomp}()},
\code{\link{tidy.prcomp}()},
\code{\link{tidy_svd}()}
}
\concept{list tidiers}
\concept{svd tidiers}
