% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/card.R
\name{card_body}
\alias{card_body}
\alias{card_title}
\alias{card_header}
\alias{card_footer}
\alias{card_image}
\alias{as.card_item}
\alias{is.card_item}
\title{Card items}
\usage{
card_body(
  ...,
  fillable = TRUE,
  min_height = NULL,
  max_height = NULL,
  max_height_full_screen = max_height,
  height = NULL,
  padding = NULL,
  gap = NULL,
  fill = TRUE,
  class = NULL
)

card_title(..., container = htmltools::h5)

card_header(..., class = NULL, container = htmltools::div)

card_footer(..., class = NULL)

card_image(
  file,
  ...,
  alt = "",
  src = NULL,
  href = NULL,
  border_radius = c("auto", "top", "bottom", "all", "none"),
  mime_type = NULL,
  class = NULL,
  height = NULL,
  fill = FALSE,
  width = NULL,
  container = NULL
)

as.card_item(x)

is.card_item(x)
}
\arguments{
\item{...}{Unnamed arguments can be any valid child of an \link[htmltools:builder]{htmltools tag}. Named arguments become HTML attributes on returned
UI element.}

\item{fillable}{Whether or not the card item should be a fillable (i.e.
flexbox) container.}

\item{min_height, max_height, max_height_full_screen}{Any valid \link[htmltools:validateCssUnit]{CSS length unit}.}

\item{height}{Any valid \link[htmltools:validateCssUnit]{CSS unit} (e.g.,
\code{height="200px"}). Doesn't apply when a card is made \code{full_screen}
(in this case, consider setting a \code{height} in \code{\link[=card_body]{card_body()}}).}

\item{padding}{Padding to use for the body. This can be a numeric vector
(which will be interpreted as pixels) or a character vector with valid CSS
lengths. The length can be between one and four. If one, then that value
will be used for all four sides. If two, then the first value will be used
for the top and bottom, while the second value will be used for left and
right. If three, then the first will be used for top, the second will be
left and right, and the third will be bottom. If four, then the values will
be interpreted as top, right, bottom, and left respectively.}

\item{gap}{A \link[htmltools:validateCssUnit]{CSS length unit} defining the
\code{gap} (i.e., spacing) between elements provided to \code{...}. This argument is only applicable when \code{fillable = TRUE}}

\item{fill}{Whether to allow this element to grow/shrink to fit its \code{card()}
container.}

\item{class}{Additional CSS classes for the returned UI element.}

\item{container}{A function to generate an HTML element to contain the image.
Setting this value to \code{card_body()} places the image inside the card body
area, otherwise the image will extend to the edges of the card.}

\item{file}{A file path pointing an image. Local images (i.e. not a URI
starting with \verb{https://} or similar) will be base64 encoded and provided to
the \code{src} attribute of the \verb{<img>}. Alternatively, you may directly set
the image \code{src}, in which case \code{file} is ignored.}

\item{alt}{Alternate text for the image, used by screen readers and assistive
devices. Provide alt text with a description of the image for any images
with important content. If alt text is not provided, the image will be
considered to be decorative and will not be read or announced by screen
readers.

For more information, the Web Accessibility Initiative (WAI) has a
\href{https://www.w3.org/WAI/tutorials/images/}{helpful tutorial on alt text}.}

\item{src}{The \code{src} attribute of the \verb{<img>} tag. If provided, \code{file} is
ignored entirely. Use \code{src} to provide a relative path to a file that will
be served by the Shiny application and should not be base64 encoded.}

\item{href}{An optional URL to link to when a user clicks on the image.}

\item{border_radius}{Which side of the image should have rounded corners,
useful when \code{card_image()} is used as an image cap at the top or bottom of
the card.

The value of \code{border_radius} determines whether the \code{card-img-top}
(\code{"top"}), \code{card-img-bottom} (\code{"bottom"}), or \code{card-img} (\code{"all"})
\href{https://getbootstrap.com/docs/5.3/components/card/#images}{Bootstrap classes} are
applied to the card. The default \code{"auto"} value will use the image's
position within a \code{card()} to automatically choose the appropriate class.}

\item{mime_type}{The mime type of the \code{file} when it is base64 encoded. This
argument is available for advanced use cases where \code{\link[mime:guess_type]{mime::guess_type()}} is
unable to automatically determine the file type.}

\item{width}{Any valid \link[htmltools:validateCssUnit]{CSS unit} (e.g.,
\code{width="100\%"}).}

\item{x}{an object to test (or coerce to) a card item.}
}
\value{
An \code{\link[htmltools:builder]{htmltools::div()}} tag.
}
\description{
Components designed to be provided as direct children of a \code{\link[=card]{card()}}. For a
general overview of the \code{\link[=card]{card()}} API, see \href{https://rstudio.github.io/bslib/articles/cards/index.html}{the Cards article} or the
other articles listed in the \emph{References} section of the \code{\link[=card]{card()}}
documentation.
}
\section{Functions}{
\itemize{
\item \code{card_body()}: A general container for the "main content" of a \code{\link[=card]{card()}}.

\item \code{card_title()}: Similar to \code{card_header()} but without the border and background color.

\item \code{card_header()}: A header (with border and background color) for the \code{card()}. Typically appears before a \code{card_body()}.

\item \code{card_footer()}: A header (with border and background color) for the \code{card()}. Typically appears after a \code{card_body()}.

\item \code{card_image()}: Include static images in a card, for example as an
image cap at the top or bottom of the card.

\item \code{as.card_item()}: Mark an object as a card item. This will prevent the
\code{\link[=card]{card()}} from putting the object inside a \code{wrapper} (i.e., a
\code{card_body()}).

}}
\seealso{
\code{\link[=card]{card()}} creates a card component.

\code{\link[=navset_card_tab]{navset_card_tab()}}, \code{\link[=navset_card_pill]{navset_card_pill()}} and
\code{\link[=navset_card_underline]{navset_card_underline()}} create cards with tabbed navigation.

\code{\link[=layout_columns]{layout_columns()}} and \code{\link[=layout_column_wrap]{layout_column_wrap()}} help position multiple
cards into columns and rows and can also be used inside a card.

\code{\link[=layout_sidebar]{layout_sidebar()}} adds a sidebar to a card when nested in \code{\link[=card]{card()}}
or \code{\link[=card_body]{card_body()}}.
}
