% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_discrimination.R
\name{evaluate_discrimination}
\alias{evaluate_discrimination}
\title{evaluate_discrimination}
\usage{
evaluate_discrimination(actual, predicted, cutoff = NULL)
}
\arguments{
\item{actual}{vector of observed class labels (0/1)}

\item{predicted}{vector of uncalibrated predictions}

\item{cutoff}{cut-off to be used for the computation of npv, ppv, sensitivity and specificity, Default: value that maximizes sensitivity and specificity (Youden-Index)}
}
\value{
list object with the following components:
\item{sens}{sensitivity}
\item{spec}{specificity}
\item{acc}{accuracy}
\item{ppv}{positive predictive value}
\item{npv}{negative predictive value}
\item{cutoff}{cut-off that was used to compute the error values}
\item{auc}{AUC value}
}
\description{
computes various discrimination error values, namely: sensitivity, specificity, accuracy, positive predictive value (ppv), negative predictive value (npv) and AUC
}
\seealso{
\code{\link[pROC]{roc}}
}
