% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_CLE.R
\name{get_CLE_class}
\alias{get_CLE_class}
\title{get_CLE_class}
\usage{
get_CLE_class(actual, predicted, bins = 10)
}
\arguments{
\item{actual}{vector of observed class labels (0/1)}

\item{predicted}{vector of uncalibrated predictions}

\item{bins}{number of bins for the equal-width binning model, default=10}
}
\value{
object of class list containing the following components:
\item{class_1}{CLE of class 1 instances}
\item{class_0}{CLE of class 0 instances}
}
\description{
calculates the class-specific classification error CLE in the test set.
The method computes the deviation of the calibrated predictions of class 1 instances from their true value 1.
For class 0 instances, \code{get_CLE_class} computes the deviation from 0.
Class 1 CLE is 0 when all class 1 instances have a calibrated prediction of 1 regardless of potential miscalibration of class 0 instances.
CLE calculation is helpful when miscalibration and -classification is more cost-sensitive for one class than for the other.
}
\seealso{
\code{\link[reshape2]{melt}}
 \code{\link[ggplot2]{ggplot}},\code{\link[ggplot2]{geom_line}},\code{\link[ggplot2]{aes}},\code{\link[ggplot2]{position_dodge}},\code{\link[ggplot2]{labs}},\code{\link[ggplot2]{scale_colour_manual}}
}
