% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/err.R
\name{message_chk}
\alias{message_chk}
\title{Construct Tidyverse Style Message}
\usage{
message_chk(..., n = NULL, tidy = TRUE)
}
\arguments{
\item{...}{Multiple objects that are converted to a string using
\code{paste0(..., collapse = '')}.}

\item{n}{The value of n for converting \code{sprintf}-like types.}

\item{tidy}{A flag specifying whether capitalize the first character and add a missing period.}
}
\value{
A string of the message.
}
\description{
If \code{tidy = TRUE} constructs a tidyverse style message by
}
\details{
\itemize{
\item Capitalizing the first character if possible.
\item Adding a trailing . if missing.
}

Also if \code{n != NULL} replaces the recognized \code{sprintf}-like types.
}
\section{\code{sprintf}-like types}{


The following recognized \code{sprintf}-like types can be used in a message:

\describe{
\item{\code{n}}{The value of n.}
\item{\code{s}}{'' if n == 1 otherwise 's'}
\item{\code{r}}{'is' if n == 1 otherwise 'are'}
\item{\code{y}}{'y' if n == 1 otherwise 'ie'}
}
}

\examples{
message_chk("there \%r \%n", " problem director\%y\%s")
message_chk("there \%r \%n", " problem director\%y\%s", n = 1)
message_chk("There \%r \%n", " problem director\%y\%s.", n = 3)
}
