% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs.R
\name{inline-markup}
\alias{inline-markup}
\title{CLI inline markup}
\description{
CLI inline markup
}
\section{Command substitution}{


All text emitted by cliapp supports glue interpolation. Expressions
enclosed by braces will be evaluated as R code. See \code{\link[glue:glue]{glue::glue()}} for
details.

In addition to regular glue interpolation, cliapp can also add classes
to parts of the text, and these classes can be used in themes. For
example\preformatted{cli_text("This is {emph important}.")
}

adds a class to the "important" word, class "emph". Note that in this
cases the string within the braces is not a valid R expression. If you
want to mix classes with interpolation, add another pair of braces:\preformatted{adjective <- "great"
cli_text("This is {emph {adjective}}.")
}

An inline class will always create a \code{span} element internally. So in
themes, you can use the \code{span.emph} CSS selector to change how inline
text is emphasized:\preformatted{cli_div(theme = list(span.emph = list(color = "red")))
adjective <- "nice and red"
cli_text("This is {emph {adjective}}.")
}
}

\section{Classes}{


The default theme defines the following inline classes:
\itemize{
\item \code{emph} for emphasized text.
\item \code{strong} for strong importance.
\item \code{code} for a piece of code.
\item \code{pkg} for a package name.
\item \code{fun} for a function name.
\item \code{arg} for a function argument.
\item \code{key} for a keyboard key.
\item \code{file} for a file name.
\item \code{path} for a path (essentially the same as \code{file}).
\item \code{email} for an email address.
\item \code{url} for a URL.
\item \code{var} for a variable name.
\item \code{envvar} for the name of an environment variable.
}

See examples below.

You can simply add new classes by defining them in the theme, and then
using them, see the example below.
}

\examples{
## Some inline markup examples
cli_ul()
cli_it("{emph Emphasized} text")
cli_it("{strong Strong} importance")
cli_it("A piece of code: {code sum(a) / length(a)}")
cli_it("A package name: {pkg cliapp}")
cli_it("A function name: {fun cli_text}")
cli_it("A function argument: {arg text}")
cli_it("A keyboard key: press {key ENTER}")
cli_it("A file name: {file /usr/bin/env}")
cli_it("An email address: {email bugs.bunny@acme.com}")
cli_it("A URL: {url https://acme.com}")
cli_it("A variable name: {var mtcars}")
cli_it("An environment variable: {envvar R_LIBS}")
cli_end()

## Adding a new class
cli_div(theme = list(
  span.myclass = list(color = "lightgrey"),
  "span.myclass::before" = list(content = "["),
  "span.myclass::after" = list(content = "]")))
cli_text("This is {myclass in brackets}.")
cli_end()
}
