% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date.R
\name{date-and-date-time-shifting}
\alias{date-and-date-time-shifting}
\alias{date_shift}
\title{Shifting: date and date-time}
\usage{
date_shift(x, target, ..., which = "next", boundary = "keep")
}
\arguments{
\item{x}{\verb{[Date / POSIXct / POSIXlt]}

A date or date-time vector.}

\item{target}{\verb{[weekday]}

A weekday created from \code{\link[=weekday]{weekday()}} to target.

Generally this is length 1, but can also be the same length as \code{x}.}

\item{...}{These dots are for future extensions and must be empty.}

\item{which}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"next"}: Shift to the next instance of the \code{target} weekday.
\item \verb{"previous}: Shift to the previous instance of the \code{target} weekday.
}}

\item{boundary}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"keep"}: If \code{x} is currently on the \code{target} weekday, return it.
\item \code{"advance"}: If \code{x} is currently on the \code{target} weekday, advance it
anyways.
}}
}
\value{
\code{x} shifted to the \code{target} weekday.
}
\description{
\code{date_shift()} shifts \code{x} to the \code{target} weekday. You can shift to the next
or previous weekday. If \code{x} is currently on the \code{target} weekday, you can
choose to leave it alone or advance it to the next instance of the \code{target}.

There are separate help pages for shifting dates and date-times:
\itemize{
\item \link[=date-shifting]{dates (Date)}
\item \link[=posixt-shifting]{date-times (POSIXct/POSIXlt)}
}
}
\examples{
# See the type specific documentation for more examples

x <- as.Date("2019-01-01") + 0:1

# A Tuesday and Wednesday
as_weekday(x)

monday <- weekday(clock_weekdays$monday)

# Shift to the next Monday
date_shift(x, monday)
}
