% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rma-mv.R
\name{findCluster.rma.mv}
\alias{findCluster.rma.mv}
\title{Detect cluster structure of an rma.mv object}
\usage{
findCluster.rma.mv(obj)
}
\arguments{
\item{obj}{A fitted \code{rma.mv} object.}
}
\value{
A a vector of ID variables for the highest level of clustering in \code{obj}.
}
\description{
\code{findCluster.rma.mv} returns a vector of ID variables for the highest level of clustering in a fitted \code{rma.mv} model.
}
\examples{

if (requireNamespace("metafor", quietly = TRUE)) {

library(metafor)
data(dat.assink2016, package = "metadat")

mfor_fit <- rma.mv(yi ~ year + deltype, 
                 V = vi, random = ~ 1 | study / esid,
                 data = dat.assink2016)
                 
findCluster.rma.mv(mfor_fit)

}

}
