% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrRect.R
\name{corrRect}
\alias{corrRect}
\title{Draw rectangle(s) on the correlation matrix graph.}
\usage{
corrRect(
  corrRes = NULL,
  index = NULL,
  name = NULL,
  namesMat = NULL,
  col = "black",
  lwd = 2,
  ...
)
}
\arguments{
\item{corrRes}{List of the \code{corrplot()} returns.}

\item{index}{Vector, variable index of diag rect \code{c(Rect1from, Rect2from,
Rect3from, ..., RectNto)} on the correlation matrix graph.
It works when the colnames are the same as rownames, or both of them is NULL.
It needs \code{corrRes} inputted.}

\item{name}{Vector, variable name of diag rect \code{c(Rect1from, Rect2from,
Rect3from, ..., RectNto)} on the correlation matrix graph.
OIt works when the colnames are the same as rownames.
It needs \code{corrRes} inputted.}

\item{namesMat}{4-length character vector or 4-columns character matrix,
represents the names of xleft, ybottom, xright, ytop correspondingly.
It needs \code{corrRes} inputted.}

\item{col}{Color of rectangles.}

\item{lwd}{Line width of rectangles.}

\item{\dots}{Additional arguments passing to function \code{rect()}.}
}
\value{
(Invisibly) returns input parameter \code{corrRes},
usually \code{list(corr, corrTrans, arg)}.
}
\description{
Draw rectangle(s) after the correlation matrix plotted. SUGGESTION: It's more convenient
to draw rectangle(s) by using pipe operator `|>` since R 4.1.0.
}
\details{
\code{corrRect} needs one of \code{index}, \code{name} and \code{namesMat} inputted.
While \code{corrRect.hclust} can get the members in each cluster
based on hierarchical clustering (\code{\link{hclust}}).
}
\examples{
data(mtcars)
M = cor(mtcars)

r = rbind(c('gear', 'wt', 'qsec', 'carb'),
        c('wt', 'gear', 'carb', 'qsec'))
corrplot(M, order = 'AOE') -> p
corrRect(p, namesMat = r)

#  same as using pipe operator `|>` if R version >= 4.1.0:
#  corrplot(M, order = 'AOE') |> corrRect(namesMat = r)



r = c('gear', 'carb', 'qsec', 'wt')
corrplot(M, order = 'AOE', type='lower') -> p
corrRect(p, namesMat = r)

# same as using pipe operator `|>` if R version >= 4.1.0:
# corrplot(M, order = 'AOE', type='lower') |> corrRect(namesMat = r)



corrplot(M, order = 'hclust', type = 'upper') -> p
corrRect(p, index = c(1, 6, 11))

#  same as using pipe operator `|>` if R version >= 4.1.0:
#  corrplot(M, order = 'AOE', type='lower') |> corrRect(index = c(1, 6, 11))



corrplot(M, order = 'hclust') -> p
corrRect(p, name = c('carb', 'qsec', 'gear'))

#  same as using pipe operator `|>` if R version >= 4.1.0:
#  corrplot(M, order = 'hclust') |> corrRect(name = c('carb', 'qsec', 'gear'))




(order.hc = corrMatOrder(M, order = 'hclust'))
(order.hc2 = corrMatOrder(M, order = 'hclust', hclust.method = 'ward.D'))
M.hc  = M[order.hc, order.hc]
M.hc2 = M[order.hc2, order.hc2]

par(ask = TRUE)

# same as: corrplot(M, order = 'hclust', addrect = 2)
corrplot(M.hc)
corrRect.hclust(corr = M.hc, k = 2)

# same as: corrplot(M, order = 'hclust', addrect = 3)
corrplot(M.hc)
corrRect.hclust(corr = M.hc, k = 3)

# same as: corrplot(M, order = 'hclust', hclust.method = 'ward.D', addrect = 2)
corrplot(M.hc2)
corrRect.hclust(M.hc2, k = 2, method = 'ward.D')

# same as: corrplot(M, order = 'hclust', hclust.method = 'ward.D', addrect = 3)
corrplot(M.hc2)
corrRect.hclust(M.hc2, k = 3, method = 'ward.D')

# same as: corrplot(M, order = 'hclust', hclust.method = 'ward.D', addrect = 4)
corrplot(M.hc2)
corrRect.hclust(M.hc2, k = 4, method = 'ward.D')
}
\author{
Taiyun Wei
}
\keyword{hplot}
