% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_node_present.R
\name{is_node_present}
\alias{is_node_present}
\title{Determine whether a specified node is present}
\usage{
is_node_present(graph, node)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{node}{Either a node ID value or a node label to test for presence in
the graph.}
}
\value{
A logical value.
}
\description{
From a graph object of class \code{dgr_graph}, determine whether a specified node
is present.
}
\examples{
# Create a simple graph with
# a path of four nodes
graph <-
  create_graph() \%>\%
  add_path(
    n = 4,
    type = "path",
    label = c(
      "one", "two",
      "three", "four"))

# Determine if there is a node
# with ID `1` in the graph
graph \%>\%
  is_node_present(node = 1)

# Determine if there is a node
# with ID `5` in the graph
graph \%>\%
  is_node_present(node = 5)

# Determine if there is a node
# with label `two` in the graph
graph \%>\%
  is_node_present(node = "two")
}
