% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_node_attrs.R
\name{join_node_attrs}
\alias{join_node_attrs}
\title{Join new node attribute values using a data frame}
\usage{
join_node_attrs(graph, df, by_graph = NULL, by_df = NULL)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{df}{The data frame to use for joining.}

\item{by_graph}{Optional specification of the column in the graph's internal
node data frame for the left join. If both \code{by_graph} and \code{by_df} are not
provided, then a natural join will occur if there are columns in the
graph's ndf and in \code{df} with identical names.}

\item{by_df}{Optional specification of the column in \code{df} for the left join.
If both \code{by_graph} and \code{by_df} are not provided, then a natural join will
occur if there are columns in the graph's ndf and in \code{df} with identical
names.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
Join new node attribute values in a left join using a data frame. The use of
a left join in this function allows for no possibility that nodes in the
graph might be removed after the join.
}
\examples{
# Set a seed
suppressWarnings(RNGversion("3.5.0"))
set.seed(23)

# Create a simple graph
graph <-
  create_graph() \%>\%
  add_n_nodes(n = 5) \%>\%
  add_edges_w_string(
    edges = "1->2 1->3 2->4 2->5 3->5")

# Create a data frame with node ID values and a
# set of numeric values
df <-
  data.frame(
    values = round(rnorm(6, 5), 2),
    id = 1:6)

# Join the values in the data frame to the
# graph's nodes; this works as a left join using
# identically-named columns in the graph and the df
# (in this case the `id` column is common to both)
graph <-
  graph \%>\%
  join_node_attrs(
    df = df)

# Get the graph's internal ndf to show that the
# join has been made
graph \%>\% get_node_df()

# Get betweenness values for each node and
# add them as a node attribute (Note the
# common column name `id` in the different
# tables results in a natural join)
graph <-
  graph \%>\%
  join_node_attrs(
    df = get_betweenness(.))

# Get the graph's internal ndf to show that
# this join has been made
graph \%>\% get_node_df()
}
\seealso{
Other node creation and removal: 
\code{\link{add_n_node_clones}()},
\code{\link{add_n_nodes}()},
\code{\link{add_n_nodes_ws}()},
\code{\link{add_node}()},
\code{\link{add_node_clones_ws}()},
\code{\link{add_node_df}()},
\code{\link{add_nodes_from_df_cols}()},
\code{\link{add_nodes_from_table}()},
\code{\link{colorize_node_attrs}()},
\code{\link{copy_node_attrs}()},
\code{\link{create_node_df}()},
\code{\link{delete_node}()},
\code{\link{delete_nodes_ws}()},
\code{\link{drop_node_attrs}()},
\code{\link{layout_nodes_w_string}()},
\code{\link{mutate_node_attrs}()},
\code{\link{mutate_node_attrs_ws}()},
\code{\link{node_data}()},
\code{\link{recode_node_attrs}()},
\code{\link{rename_node_attrs}()},
\code{\link{rescale_node_attrs}()},
\code{\link{set_node_attr_to_display}()},
\code{\link{set_node_attr_w_fcn}()},
\code{\link{set_node_attrs}()},
\code{\link{set_node_attrs_ws}()},
\code{\link{set_node_position}()}
}
\concept{node creation and removal}
