% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimRedResult-class.R
\docType{class}
\name{dimRedResult-class}
\alias{dimRedResult-class}
\alias{dimRedResult}
\alias{predict,dimRedResult-method}
\alias{inverse,dimRedResult-method}
\alias{inverse}
\alias{as.data.frame,dimRedResult-method}
\alias{getPars,dimRedResult-method}
\alias{print,dimRedResult-method}
\alias{getOrgData,dimRedResult-method}
\alias{getDimRedData,dimRedResult-method}
\alias{ndims,dimRedResult-method}
\title{Class "dimRedResult"}
\usage{
\S4method{predict}{dimRedResult}(object, xnew)

\S4method{inverse}{dimRedResult}(object, ynew)

\S4method{as.data.frame}{dimRedResult}(x, org.data.prefix = "org.",
  meta.prefix = "meta.", data.prefix = "")

\S4method{getPars}{dimRedResult}(object)

\S4method{print}{dimRedResult}(x)

\S4method{getOrgData}{dimRedResult}(object)

\S4method{getDimRedData}{dimRedResult}(object)

\S4method{ndims}{dimRedResult}(object)
}
\arguments{
\item{object}{Of class \code{dimRedResult}}

\item{xnew}{new data, of type \code{\link{dimRedData}}}

\item{ynew}{embedded data, of type \code{\link{dimRedData}}}

\item{x}{Of class \code{dimRedResult}}

\item{org.data.prefix}{Prefix for the columns of the org.data slot.}

\item{meta.prefix}{Prefix for the columns of \code{x@data@meta}.}

\item{data.prefix}{Prefix for the columns of \code{x@data@data}.}
}
\description{
A class to hold the results of of a dimensionality reduction.
}
\section{Methods (by generic)}{
\itemize{
\item \code{predict}: apply a trained method to new data, does not work
with all methods, will give an error if there is no \code{apply}.
In some cases the apply function may only be an approximation.

\item \code{inverse}: inverse transformation of embedded data, does not
work with all methods, will give an error if there is no \code{inverse}.
In some cases the apply function may only be an approximation.

\item \code{as.data.frame}: convert to \code{data.frame}

\item \code{getPars}: Get the parameters with which the method
was called.

\item \code{print}: Method for printing.

\item \code{getOrgData}: Get the original data and meta.data

\item \code{getDimRedData}: Get the embedded data

\item \code{ndims}: Extract the number of embedding dimensions.
}}

\section{Slots}{

\describe{
\item{\code{data}}{Output data of class dimRedData.}

\item{\code{org.data}}{original data, a matrix.}

\item{\code{apply}}{a function to apply the method to out-of-sampledata,
may not exist.}

\item{\code{inverse}}{a function to calculate the original coordinates from
reduced space, may not exist.}

\item{\code{has.org.data}}{logical, if the original data is included in the object.}

\item{\code{has.apply}}{logical, if a forward method is exists.}

\item{\code{has.inverse}}{logical if an inverse method exists.}

\item{\code{method}}{saves the method used.}

\item{\code{pars}}{saves the parameters used.}
}}

\examples{
## Create object by embedding data
iris.pca <- embed(loadDataSet("Iris"), "PCA")

## Convert the result to a data.frame
head(as(iris.pca, "data.frame"))
head(as.data.frame(iris.pca))

## There are no nameclashes to avoid here:
head(as.data.frame(iris.pca,
                   org.data.prefix = "",
                   meta.prefix     = "",
                   data.prefix     = ""))

## Print it more or less nicely:
print(iris.pca)

## Get the embedded data as a dimRedData object:
getDimRedData(iris.pca)

## Get the original data including meta information:
getOrgData(iris.pca)

## Get the number of variables:
ndims(iris.pca)

}
