% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_modelling.R
\name{add_pred}
\alias{add_pred}
\title{Add predicted values of different types to dataframe}
\usage{
add_pred(data, model, var = "pred", type = NULL, transformation = NULL)
}
\arguments{
\item{data}{dataframe or tibble}

\item{model}{model object}

\item{var}{name of new variable in dataframe / tibble}

\item{type}{type of predicted value}

\item{transformation}{A possible transformation of predicted variable, e.g. reciprocal(), log() etc}
}
\value{
dataframe / tibble
}
\description{
Add predicted values of different types to dataframe
}
\examples{
data(cars)
lm1 <- lm(dist ~ speed + I(speed^2), data=cars)
lm1 |> response() |> head()
cars <- cars |> add_pred(lm1)
cars |> head()
cars <- cars |> add_resid(lm1)
cars

}
\author{
Søren Højsgaard
}
