### R code from vignette source 'filehash.Rnw'

###################################################
### code chunk number 1: options
###################################################
options(width=60)


###################################################
### code chunk number 2: exampleGlobalEnv
###################################################
x <- 1
print(x)


###################################################
### code chunk number 3: create
###################################################
library(filehash)
dbCreate("mydb")
db <- dbInit("mydb")


###################################################
### code chunk number 4: setseed1
###################################################
set.seed(100)


###################################################
### code chunk number 5: insert
###################################################
dbInsert(db, "a", rnorm(100))


###################################################
### code chunk number 6: fetch
###################################################
value <- dbFetch(db, "a")
mean(value)


###################################################
### code chunk number 7: delete
###################################################
dbInsert(db, "b", 123)
dbDelete(db, "a")
dbList(db)
dbExists(db, "a")


###################################################
### code chunk number 8: accessors
###################################################
db$a <- rnorm(100, 1)
mean(db$a)
mean(db[["a"]])
db$b <- rnorm(100, 2)
dbList(db)


###################################################
### code chunk number 9: characteronly
###################################################
e <- local({
    err <- function(e) e
    tryCatch(db[[1]], error = err)
})
conditionMessage(e)


###################################################
### code chunk number 10: with
###################################################
with(db, c(a = mean(a), b = mean(b)))


###################################################
### code chunk number 11: sapply
###################################################
sapply(db[c("a", "b")], mean)


###################################################
### code chunk number 12: lapply
###################################################
unlist(lapply(db, mean))


###################################################
### code chunk number 13: cleanupMyDB
###################################################
dbUnlink(db)
rm(list = ls(all = TRUE))


###################################################
### code chunk number 14: setseed2
###################################################
set.seed(200)


###################################################
### code chunk number 15: testDB
###################################################
dbCreate("testDB")
db <- dbInit("testDB")
db$x <- rnorm(100)
db$y <- runif(100)
db$a <- letters
dbLoad(db)
ls()


###################################################
### code chunk number 16: accessbinding
###################################################
mean(y)
sort(a)


###################################################
### code chunk number 17: assignvalue
###################################################
y <- rnorm(100, 2)
mean(y)


###################################################
### code chunk number 18: removeandload
###################################################
rm(list = ls())
db <- dbInit("testDB")
dbLoad(db)
ls()
mean(y)


###################################################
### code chunk number 19: cleanupTestDB
###################################################
dbUnlink(db)
rm(list = ls(all = TRUE))


