% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment_rows.R
\name{add_footer_lines}
\alias{add_footer_lines}
\title{Add labels as new rows in the footer}
\usage{
add_footer_lines(x, values = character(0), top = FALSE)
}
\arguments{
\item{x}{a \code{flextable} object}

\item{values}{a character vector or a call to \code{\link[=as_paragraph]{as_paragraph()}}
to get formated content, each element will
be added as a new row.}

\item{top}{should the row be inserted at the top
or the bottom. Default to TRUE.}
}
\description{
Add labels as new rows in the footer,
where all columns are merged.

This is a sugar function to be used when you need to
add labels in the footer, a footnote for example.
}
\examples{
ft_1 <- flextable(head(iris))
ft_1 <- add_footer_lines(ft_1,
  values = c("blah 1", "blah 2")
)
ft_1
}
\seealso{
Other functions for row and column operations in a flextable: 
\code{\link{add_body_row}()},
\code{\link{add_body}()},
\code{\link{add_footer_row}()},
\code{\link{add_footer}()},
\code{\link{add_header_row}()},
\code{\link{add_header}()},
\code{\link{delete_columns}()},
\code{\link{delete_part}()},
\code{\link{delete_rows}()},
\code{\link{separate_header}()},
\code{\link{set_header_footer_df}},
\code{\link{set_header_labels}()}
}
\concept{functions for row and column operations in a flextable}
