% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment_rows.R
\name{add_footer_row}
\alias{add_footer_row}
\title{Add footer labels}
\usage{
add_footer_row(x, top = TRUE, values = character(0), colwidths = integer(0))
}
\arguments{
\item{x}{a flextable object}

\item{top}{should the row be inserted at the top or the bottom.}

\item{values}{values to add. It can be a \code{list}, a \code{character()} vector
or a call to \code{\link[=as_paragraph]{as_paragraph()}}.

If it is a list, it can be a named list with the names of the columns of the
original data.frame or the \code{colkeys}; this is the recommended method because
it allows to keep the original data types and therefore allows to perform
conditional formatting. If a character, columns of the original data.frame
stored in the flextable object are changed to \code{character()}; this is often
not an issue with footer and header but can be inconvenient if adding
rows into body as it will change data types to character and prevent
efficient conditional formatting.}

\item{colwidths}{the number of columns to merge in the row for each label}
}
\description{
Add a row of new columns labels in footer part.
Labels can be spanned along multiple columns, as merged cells.

Labels are associated with a number of columns
to merge that default to one if not specified.
In this case, you have to make sure that the
number of labels is equal to the number of columns displayed.

The function can add only one single row by call.

Labels can be formatted with \code{\link[=as_paragraph]{as_paragraph()}}.
}
\examples{
library(flextable)

ft01 <- fp_text_default(color = "red")
ft02 <- fp_text_default(color = "orange")

pars <- as_paragraph(
  as_chunk(c("(1)", "(2)"), props = ft02), " ",
  as_chunk(
    c(
      "My tailor is rich",
      "My baker is rich"
    ),
    props = ft01
  )
)

ft_1 <- flextable(head(mtcars))
ft_1 <- add_footer_row(ft_1,
  values = pars,
  colwidths = c(5, 6), top = FALSE
)
ft_1 <- add_footer_row(ft_1,
  values = pars,
  colwidths = c(3, 8), top = TRUE
)
ft_1

ft_2 <- flextable(head(airquality))
ft_2 <- add_footer_row(ft_2,
  values = c("Measure", "Time"),
  colwidths = c(4, 2), top = TRUE
)
ft_2 <- theme_box(ft_2)
ft_2
}
\seealso{
\code{\link[=flextable]{flextable()}}, \code{\link[=set_caption]{set_caption()}}

Other functions for row and column operations in a flextable: 
\code{\link{add_body_row}()},
\code{\link{add_body}()},
\code{\link{add_footer_lines}()},
\code{\link{add_footer}()},
\code{\link{add_header_row}()},
\code{\link{add_header}()},
\code{\link{delete_columns}()},
\code{\link{delete_part}()},
\code{\link{delete_rows}()},
\code{\link{separate_header}()},
\code{\link{set_header_footer_df}},
\code{\link{set_header_labels}()}
}
\concept{functions for row and column operations in a flextable}
