% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printers.R
\name{knit_print.flextable}
\alias{knit_print.flextable}
\title{Render flextable with 'knitr'}
\usage{
\method{knit_print}{flextable}(x, ...)
}
\arguments{
\item{x}{a \code{flextable} object}

\item{...}{unused.}
}
\description{
Function used to render flextable in knitr/rmarkdown documents.

You should not call this method directly. This function is used by the knitr
package to automatically display a flextable in an "R Markdown" document from
a chunk. However, it is recommended to read its documentation in order to get
familiar with the different options available.

R Markdown outputs can be :
\itemize{
\item HTML
\item 'Microsoft Word'
\item 'Microsoft PowerPoint'
\item PDF
}

\if{html}{\figure{fig_formats.png}{options: width="200"}}

Table captioning is a flextable feature compatible with R Markdown
documents. The feature is available for HTML, PDF and Word documents.
Compatibility with the "bookdown" package is also ensured, including the
ability to produce captions so that they can be used in cross-referencing.

For Word, it's recommanded to work with package 'officedown' that supports
all features of flextable.
}
\note{
Supported formats require some
minimum \href{https://pandoc.org/installing.html}{pandoc} versions:

\tabular{rc}{
\strong{Output format} \tab \strong{pandoc minimal version} \cr
HTML              \tab >= 1.12\cr
Word (docx)       \tab >= 2.0 \cr
PowerPoint (pptx) \tab >= 2.4 \cr
PDF               \tab >= 1.12
}

If the output format is not HTML, Word, or PDF (e.g., \code{rtf_document},
\code{github_document}, \code{beamer_presentation}), an image will be generated
instead.
}
\section{Chunk options}{


Some features, often specific to an output format, are available to help you
configure some global settings relatve to the table output. knitr's chunk options
are to be used to change the default settings:
\itemize{
\item HTML, PDF and Word:
\itemize{
\item \code{ft.align}: flextable alignment, supported values are 'left', 'center'
and 'right'. Its default value is 'center'.
}
\item HTML only:
\itemize{
\item \code{ft.htmlscroll}, can be \code{TRUE} or \code{FALSE} (default) to enable
horizontal scrolling. Use \code{\link[=set_table_properties]{set_table_properties()}} for more
options about scrolling.
}
\item Word only:
\itemize{
\item \code{ft.split} Word option 'Allow row to break across pages' can be
activated when TRUE (default value).
\item \code{ft.keepnext} defunct in favor of \code{\link[=paginate]{paginate()}}
}
\item PDF only:
\itemize{
\item \code{ft.tabcolsep} space between the text and the left/right border of its containing
cell, the default value is 0 points.
\item \code{ft.arraystretch} height of each row relative to its default
height, the default value is 1.5.
\item \code{ft.latex.float} type of floating placement in the document, one of:
\itemize{
\item 'none' (the default value), table is placed after the preceding
paragraph.
\item 'float', table can float to a place in the text where it fits best
\item 'wrap-r', wrap text around the table positioned to the right side of the text
\item 'wrap-l', wrap text around the table positioned to the left side of the text
\item 'wrap-i', wrap text around the table positioned inside edge-near the binding
\item 'wrap-o', wrap text around the table positioned outside edge-far from the binding
}
}
\item PowerPoint only:
\itemize{
\item \code{ft.left}, \code{ft.top} Position should be defined with these options.
Theses are the top left coordinates in inches of the placeholder
that will contain the table. Their default values are 1 and 2
inches.
}
}

If some values are to be used all the time in the same
document, it is recommended to set these values in a
'knitr r chunk' by using function
\code{knitr::opts_chunk$set(ft.split=FALSE, ...)}.
}

\section{Table caption}{


Captions can be defined in two ways.

The first is with the \code{\link[=set_caption]{set_caption()}} function. If it is used,
the other method will be ignored. The second method is by using
knitr chunk option \code{tab.cap}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{set_caption(x, caption = "my caption")
}\if{html}{\out{</div>}}

If \code{set_caption} function is not used, caption identifier will be
read from knitr's chunk option \code{tab.id}. Note that in a bookdown and
when not using \code{officedown::rdocx_document()}, the usual numbering
feature of bookdown is used.

\code{tab.id='my_id'}.

Some options are available to customise captions for any output:\tabular{lcc}{
   \strong{label} \tab \strong{name} \tab \strong{value} \cr
   Word stylename to use for table captions. \tab tab.cap.style \tab NULL \cr
   caption id/bookmark \tab tab.id \tab NULL \cr
   caption \tab tab.cap \tab NULL \cr
   display table caption on top of the table or not \tab tab.topcaption \tab TRUE \cr
   caption table sequence identifier. \tab tab.lp \tab "tab:" \cr
}


Word output when \code{officedown::rdocx_document()} is used is coming with
more options such as ability to choose the prefix for numbering chunk for
example. The table below expose these options:\tabular{lcc}{
   \strong{label} \tab \strong{name} \tab \strong{value} \cr
   prefix for numbering chunk (default to   "Table "). \tab tab.cap.pre \tab Table \cr
   suffix for numbering chunk (default to   ": "). \tab tab.cap.sep \tab " :" \cr
   title number depth \tab tab.cap.tnd \tab 0 \cr
   caption prefix formatting properties \tab tab.cap.fp_text \tab fp_text_lite(bold = TRUE) \cr
   separator to use between title number and table number. \tab tab.cap.tns \tab "-" \cr
}
}

\section{HTML output}{


HTML output is using shadow dom to encapsule the table
into an isolated part of the page so that no clash happens
with styles.
}

\section{PDF output}{


Some features are not implemented in PDF due to technical
infeasibility. These are the padding, line_spacing and
height properties. Note also justified text is not supported
and is transformed to left.

It is recommended to set theses values in a
'knitr r chunk' so that they are permanent
all along the document:
\code{knitr::opts_chunk$set(ft.tabcolsep=0, ft.latex.float = "none")}.

See \code{\link[=add_latex_dep]{add_latex_dep()}} if caching flextable results in 'R Markdown'
documents.
}

\section{PowerPoint output}{


Auto-adjust Layout is not available for PowerPoint, PowerPoint only support
fixed layout. It's then often necessary to call function \code{\link[=autofit]{autofit()}} so
that the columns' widths are adjusted if user does not provide the withs.

Images cannot be integrated into tables with the PowerPoint format.
}

\examples{
\dontrun{
library(rmarkdown)
if (pandoc_available() &&
  pandoc_version() > numeric_version("2")) {
  demo_loop <- system.file(
    package = "flextable",
    "examples/rmd",
    "demo.Rmd"
  )
  rmd_file <- tempfile(fileext = ".Rmd")
  file.copy(demo_loop, to = rmd_file, overwrite = TRUE)
  render(
    input = rmd_file, output_format = "html_document",
    output_file = "demo.html"
  )
}
}
}
\seealso{
\code{\link[=paginate]{paginate()}}

Other flextable print function: 
\code{\link{as_raster}()},
\code{\link{df_printer}()},
\code{\link{flextable_to_rmd}()},
\code{\link{gen_grob}()},
\code{\link{htmltools_value}()},
\code{\link{plot.flextable}()},
\code{\link{print.flextable}()},
\code{\link{save_as_docx}()},
\code{\link{save_as_html}()},
\code{\link{save_as_image}()},
\code{\link{save_as_pptx}()},
\code{\link{save_as_rtf}()},
\code{\link{to_html.flextable}()}
}
\concept{flextable print function}
