% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supportsMulticore.R
\name{supportsMulticore}
\alias{supportsMulticore}
\title{Check whether multicore/forked processing is supported or not}
\usage{
supportsMulticore(...)
}
\arguments{
\item{\dots}{Internal usage only.}
}
\value{
TRUE if forked processing is supported and not disabled,
otherwise FALSE.
}
\description{
Multicore futures require an operating system that supports \emph{forked}
processing.  Operating systems such as Unix and macOS supports forking,
whereas Microsoft Windows does not.
}
\section{Support for process forking}{

The Microsoft Windows operating system does not support processes forking.
Unix-like operating system such as Linux and macOS support forking.

For some R environments it is considered unstable to perform parallel
processing based on \emph{forking}. Because of this, the future ecosystem
disables forked processing by default when it detects that \R runs from
environment that is known to be unstable for forked processing, despite
the underlying operating system supported it.
This is for example the case when using RStudio, cf.
\href{https://github.com/rstudio/rstudio/issues/2597#issuecomment-482187011}{RStudio Inc. recommends against using forked processing when running R from within the RStudio software}.
A warning will be produced informing the user about this the first time
'multicore' or 'multiprocess' futures are used in the \R session.
This warning can be disabled by setting R option
\option{future.supportsMulticore.unstable}, or environment variable
\env{R_FUTURE_SUPPORTSMULTICORE_UNSTABLE} to \code{"quiet"}.
}

\section{Enable or disable forked processing}{

It is possible to disable forked processing for futures by setting \R
option \option{future.fork.enable} to \code{FALSE}.  Alternatively, one can
set environment variable \env{R_FUTURE_FORK_ENABLE} to \code{false}.
This will cause \code{plan(multicore)} to work as \code{plan(sequential)},
and \code{plan(multiprocess)} to work as \code{plan(multisession)}.
Analogously, it is possible to override disabled forking by setting one
of these to \code{TRUE}.
}

\seealso{
To use multicore futures, use \code{\link{plan}(\link{multicore})}.
}
\keyword{internal}
