% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cs.R
\name{cs}
\alias{cs}
\title{Credible set}
\usage{
cs(tbl, b = "Effect", se = "StdErr", log_p = NULL, cutoff = 0.95)
}
\arguments{
\item{tbl}{Input data.}

\item{b}{Effect size.}

\item{se}{Standard error.}

\item{log_p}{if not NULL it will be used to derive z-statistic}

\item{cutoff}{Threshold for inclusion.}
}
\value{
Credible set.
}
\description{
Credible set
}
\details{
The function implements credible set as in fine-mapping.
}
\examples{
\dontrun{
\preformatted{
  zcat METAL/4E.BP1-1.tbl.gz | \
  awk 'NR==1 || ($1==4 && $2 >= 187158034 - 1e6 && $2 < 187158034 + 1e6)' > 4E.BP1.z
}
  tbl <- within(read.delim("4E.BP1.z"),{logp <- logp(Effect/StdErr)})
  z <- cs(tbl)
  l <- cs(tbl,log_p="logp")
}
}
