% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-identity.r, R/zxx.r
\name{scale_identity}
\alias{scale_alpha_identity}
\alias{scale_color_identity}
\alias{scale_colour_identity}
\alias{scale_fill_identity}
\alias{scale_identity}
\alias{scale_linetype_identity}
\alias{scale_shape_identity}
\alias{scale_size_identity}
\title{Use values without scaling.}
\usage{
scale_colour_identity(..., guide = "none")

scale_fill_identity(..., guide = "none")

scale_shape_identity(..., guide = "none")

scale_linetype_identity(..., guide = "none")

scale_alpha_identity(..., guide = "none")

scale_size_identity(..., guide = "none")
}
\arguments{
\item{...}{Other arguments passed on to \code{\link{discrete_scale}} or
\code{\link{continuous_scale}}}

\item{guide}{Guide to use for this scale - defaults to \code{"none"}.}
}
\description{
Use values without scaling.
}
\examples{
ggplot(luv_colours, aes(u, v)) +
  geom_point(aes(colour = col), size = 3) +
  scale_color_identity() +
  coord_equal()

df <- data.frame(
  x = 1:4,
  y = 1:4,
  colour = c("red", "green", "blue", "yellow")
)
ggplot(df, aes(x, y)) + geom_tile(aes(fill = colour))
ggplot(df, aes(x, y)) +
  geom_tile(aes(fill = colour)) +
  scale_fill_identity()

# To get a legend guide, specify guide = "legend"
ggplot(df, aes(x, y)) +
  geom_tile(aes(fill = colour)) +
  scale_fill_identity(guide = "legend")
# But you'll typically also need to supply breaks and labels:
ggplot(df, aes(x, y)) +
  geom_tile(aes(fill = colour)) +
  scale_fill_identity("trt", labels = letters[1:4], breaks = df$colour,
  guide = "legend")

# cyl scaled to appropriate size
ggplot(mtcars, aes(mpg, wt)) + geom_point(aes(size = cyl))

# cyl used as point size
ggplot(mtcars, aes(mpg, wt)) +
  geom_point(aes(size = cyl)) +
  scale_size_identity()
}

