% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repository.R
\name{as.data.frame.git_repository}
\alias{as.data.frame.git_repository}
\title{Coerce Git repository to a \code{data.frame}}
\usage{
\method{as.data.frame}{git_repository}(x, ...)
}
\arguments{
\item{x}{The repository \code{object}}

\item{...}{Additional arguments. Not used.}
}
\value{
\code{data.frame}
}
\description{
The commits in the repository are coerced to a \code{data.frame}
}
\details{
The \code{data.frame} have the following columns:
\describe{

\item{sha}{
    The 40 character hexadecimal string of the SHA-1
  }

\item{summary}{
    the short "summary" of the git commit message.
  }

\item{message}{
    the full message of a commit
  }

\item{author}{
    full name of the author
  }

\item{email}{
    email of the author
  }

\item{when}{
    time when the commit happened
  }

}
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user
config(repo, user.name="Alice", user.email="alice@example.org")

## Create three files and commit
writeLines("First file",  file.path(path, "example-1.txt"))
writeLines("Second file", file.path(path, "example-2.txt"))
writeLines("Third file",  file.path(path, "example-3.txt"))
add(repo, "example-1.txt")
commit(repo, "Commit first file")
add(repo, "example-2.txt")
commit(repo, "Commit second file")
add(repo, "example-3.txt")
commit(repo, "Commit third file")

## Coerce commits to a data.frame
df <- as(repo, "data.frame")
df
}
}
