% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repository.R
\name{repository_head}
\alias{repository_head}
\title{Get HEAD for a repository}
\usage{
repository_head(repo = ".")
}
\arguments{
\item{repo}{a path to a repository or a \code{git_repository}
object. Default is '.'}
}
\value{
NULL if unborn branch or not found. A git_branch if not a
    detached head. A git_commit if detached head
}
\description{
Get HEAD for a repository
}
\examples{
\dontrun{
## Create and initialize a repository in a temporary directory
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)
config(repo, user.name="Alice", user.email="alice@example.org")

## Create a file, add and commit
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "Commit message")

## Get HEAD of repository
repository_head(repo)
}
}
