% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag.R
\name{tag}
\alias{tag}
\title{Create tag targeting HEAD commit in repository}
\usage{
tag(
  object = ".",
  name = NULL,
  message = NULL,
  session = FALSE,
  tagger = NULL,
  force = FALSE
)
}
\arguments{
\item{object}{The repository \code{object}.}

\item{name}{Name for the tag.}

\item{message}{The tag message. Specify a tag message to create an
annotated tag. A lightweight tag is created if the message
parameter is \code{NULL}.}

\item{session}{Add sessionInfo to tag message. Default is FALSE.}

\item{tagger}{The tagger (author) of the tag}

\item{force}{Overwrite existing tag. Default = FALSE}
}
\value{
invisible(\code{git_tag}) object
}
\description{
Create tag targeting HEAD commit in repository
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user
config(repo, user.name = "Alice", user.email = "alice@example.org")

## Commit a text file
filename <- file.path(path, "example.txt")
writeLines("Hello world!", filename)
add(repo, "example.txt")
commit(repo, "First commit message")

## Create an annotated tag
tag(repo, "v1.0", "Tag message")

## List tags
tags(repo)

## Make a change to the text file and commit.
writeLines(c("Hello world!", "HELLO WORLD!"), filename)
add(repo, "example.txt")
commit(repo, "Second commit message")

## Create a lightweight tag
tag(repo, "v2.0")

## List tags
tags(repo)
}
}
