% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Classes_H5T.R
\docType{class}
\name{H5T_ENUM-class}
\alias{H5T_ENUM-class}
\alias{H5T_ENUM}
\title{Class for HDF5 enumeration datatypes.}
\value{
Object of class \code{\link[=H5T_ENUM]{H5T_ENUM}}.
}
\description{
Inherits from class \code{\link[=H5T]{H5T}}.
}
\section{Methods}{

\describe{
\item{\code{new(labels, values = seq_along(labels), id = NULL)}}{

Create an enumeration datatype. This is either a factor-like object or a logical variable (that is
internally represented as an ENUM-type.

\strong{Parameters}
\describe{
\item{labels}{The labels of the ENUM-type}
\item{values}{The values corresponding to the labels}
\item{id}{Internal use only}
}}

\item{\code{get_labels()}}{

Return all the labels of the enumeration type}

\item{\code{get_values()}}{

Return the values of the enumeration type}

\item{\code{set_size(size)}}{

Base type of every enum is \code{H5T_INTEGER}. This disables the set_size function}

\item{\code{get_super()}}{

Returns \code{\link{H5T_INTEGER}} that is the base type of the enumeration}

\item{\code{describe()}}{

Print a detailed description of the datatype; this is experimental}
}}

\examples{
nucleotide_enum <- H5T_ENUM$new(labels=c("A", "C", "G", "T"), values=0:3)
nucleotide_enum
# For HDF5 1.8.16 or higher, the size and precision are set optimally
nucleotide_enum$get_size()
nucleotide_enum$get_precision()
}
\seealso{
\code{\link[=H5T]{H5T}}
}
\author{
Holger Hoefling
}
