% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/without-internet.R
\name{without_internet}
\alias{without_internet}
\alias{block_requests}
\title{Make all HTTP requests raise an error}
\usage{
without_internet(expr)

block_requests()
}
\arguments{
\item{expr}{Code to run inside the mock context}
}
\value{
The result of \code{expr}
}
\description{
\code{without_internet()} simulates the situation when any network request will
fail, as in when you are without an internet connection. Any HTTP request
through \code{httr2} will raise an error.
}
\details{
\code{block_requests()} and \code{stop_mocking()} allow you to turn on/off request
blocking for more convenient use in an interactive session.

The error message raised has a well-defined shape, made of three
elements, separated by space: (1) the request
method (e.g. "GET"); (2) the request URL; and
(3) the request body, if present. The verb-expectation functions,
such as \code{\link[=expect_GET]{expect_GET()}} and \code{\link[=expect_POST]{expect_POST()}}, look for this shape.
}
\examples{
library(httr2)
library(testthat, warn.conflicts = FALSE)
without_internet({
  expect_error(
    request("http://httpbin.org/get") \%>\% req_perform(),
    "GET http://httpbin.org/get"
  )
  expect_error(
    request("http://httpbin.org/put") \%>\%
      req_method("PUT") \%>\%
      req_body_json(list(a = 1)) \%>\%
      req_perform(),
    'PUT http://httpbin.org/put {"a":1}',
    fixed = TRUE
  )
})
}
