% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/huge.select.R
\name{huge.select}
\alias{huge.select}
\title{Model selection for high-dimensional undirected graph estimation}
\usage{
huge.select(est, criterion = NULL, ebic.gamma = 0.5,
  stars.thresh = 0.1, stars.subsample.ratio = NULL, rep.num = 20,
  verbose = TRUE)
}
\arguments{
\item{est}{An object with S3 class \code{"huge"}.}

\item{criterion}{Model selection criterion. \code{"ric"} and \code{"stars"} are available for all 3 graph estimation methods. \code{ebic} is only applicable when \code{est$method = "glasso"} in \code{huge()}. The default value is \code{"ric"}.}

\item{ebic.gamma}{The tuning parameter for ebic. The default value is 0.5. Only applicable when \code{est$method = "glasso"} and \code{criterion = "ebic"}.}

\item{stars.thresh}{The variability threshold in stars. The default value is \code{0.1}. An alternative value is \code{0.05}. Only applicable when \code{criterion = "stars"}.}

\item{stars.subsample.ratio}{The subsampling ratio. The default value is \code{10*sqrt(n)/n} when \code{n>144} and \code{0.8} when \code{n<=144}, where \code{n} is the sample size. Only applicable when \code{criterion = "stars"}.}

\item{rep.num}{The number of subsamplings when \code{criterion = "stars"} or rotations when \code{criterion = "ric"}. The default value is \code{20}. NOT applicable when \code{criterion = "ebic"}.}

\item{verbose}{If \code{verbose = FALSE}, tracing information printing is disabled. The default value is \code{TRUE}.}
}
\value{
An object with S3 class "select" is returned:
  \item{refit}{
    The optimal graph selected from the graph path
  }
\item{opt.icov}{
  The optimal precision matrix from the path only applicable when \code{method = "glasso"}
}
\item{opt.cov}{
  The optimal covariance matrix from the path only applicable when \code{method = "glasso"} and \code{est$cov} is available.
}
\item{merge}{
  The graph path estimated by merging the subsampling paths. Only applicable when the input \code{criterion = "stars"}.
}
\item{variability}{
  The variability along the subsampling paths. Only applicable when the input \code{criterion = "stars"}.
}
\item{ebic.scores}{
  Extended BIC scores for regularization parameter selection. Only applicable when \code{criterion = "ebic"}.
}
\item{opt.index}{
  The index of the selected regularization parameter. NOT applicable when the input \code{criterion = "ric"}
}
\item{opt.lambda}{
  The selected regularization/thresholding parameter.
}
\item{opt.sparsity}{
  The sparsity level of \code{"refit"}.
}

and anything else included in the input \code{est}
}
\description{
Implements the regularization parameter selection for high dimensional undirected graph estimation. The optional approaches are rotation information criterion (ric), stability approach to regularization selection (stars) and extended Bayesian information criterion (ebic).
}
\details{
Stability approach to regularization selection (stars) is a natural way to select optimal regularization parameter for all three estimation methods. It selects the optimal graph by variability of subsamplings and tends to overselect edges in Gaussian graphical models. Besides selecting the regularization parameters, stars can also provide an additional estimated graph by merging the corresponding subsampled graphs using the frequency counts. The subsampling procedure in stars may NOT be very efficient, we also provide the recent developed highly efficient, rotation information criterion approach (ric). Instead of tuning over a grid by cross-validation or subsampling, we directly estimate the optimal regularization parameter based on random Rotations. However, ric usually has very good empirical performances but suffers from underselections sometimes. Therefore, we suggest if user are sensitive of false negative rates, they should either consider increasing \code{r.num} or applying the stars to model selection. Extended Bayesian information criterion (ebic) is another competitive approach, but the \code{ebic.gamma} can only be tuned by experience.
}
\note{
The model selection is NOT available when the data input is the sample covariance matrix.
}
\examples{
#generate data
L = huge.generator(d = 20, graph="hub")
out.mb = huge(L$data)
out.ct = huge(L$data, method = "ct")
out.glasso = huge(L$data, method = "glasso")

#model selection using ric
out.select = huge.select(out.mb)
plot(out.select)

#model selection using stars
#out.select = huge.select(out.ct, criterion = "stars", stars.thresh = 0.05,rep.num=10)
#plot(out.select)

#model selection using ebic
out.select = huge.select(out.glasso,criterion = "ebic")
plot(out.select)
}
\seealso{
\code{\link{huge}} and \code{\link{huge-package}}.
}
